/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.mq.MQ2ClientHealthCheck;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Constants;
import org.apache.camel.component.aws2.mq.MQ2Producer;
import org.apache.camel.component.aws2.mq.client.MQ2ClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.mq.MqClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-mq", title="AWS MQ", syntax="aws2-mq:label", producerOnly=true, category={Category.CLOUD, Category.MESSAGING}, headersClass=MQ2Constants.class)
public class MQ2Endpoint
extends ScheduledPollEndpoint {
    private MqClient mqClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private MQ2ClientHealthCheck clientHealthCheck;
    @UriParam
    private MQ2Configuration configuration;

    public MQ2Endpoint(String uri, Component component, MQ2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new MQ2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.mqClient = this.configuration.getAmazonMqClient() != null ? this.configuration.getAmazonMqClient() : MQ2ClientFactory.getMqClient(this.configuration).getMqClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new MQ2ClientHealthCheck(this, this.getId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
        }
    }

    public void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonMqClient()) && this.mqClient != null) {
            this.mqClient.close();
        }
        super.doStop();
    }

    public MQ2Configuration getConfiguration() {
        return this.configuration;
    }

    public MqClient getAmazonMqClient() {
        return this.mqClient;
    }
}

