/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import java.util.Map;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.ListClustersRequest;

public class MSK2ProducerHealthCheck
extends AbstractHealthCheck {
    private final MSK2Endpoint msk2Endpoint;

    public MSK2ProducerHealthCheck(MSK2Endpoint msk2Endpoint, String clientId) {
        super("camel", "producer:aws2-msk-" + clientId);
        this.msk2Endpoint = msk2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        MSK2Configuration configuration = this.msk2Endpoint.getConfiguration();
        try {
            if (!KafkaClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            KafkaClient client = this.msk2Endpoint.getMskClient();
            client.listClusters((ListClustersRequest)ListClustersRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            builder.down();
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

