/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Endpoint;
import org.apache.camel.component.aws2.msk.MSK2Operations;
import org.apache.camel.component.aws2.msk.MSK2ProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.CreateClusterRequest;
import software.amazon.awssdk.services.kafka.model.CreateClusterResponse;
import software.amazon.awssdk.services.kafka.model.DeleteClusterRequest;
import software.amazon.awssdk.services.kafka.model.DeleteClusterResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterRequest;
import software.amazon.awssdk.services.kafka.model.DescribeClusterResponse;
import software.amazon.awssdk.services.kafka.model.ListClustersRequest;
import software.amazon.awssdk.services.kafka.model.ListClustersResponse;

public class MSK2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MSK2Producer.class);
    private transient String mskProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public MSK2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listClusters: {
                this.listClusters(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            case createCluster: {
                this.createCluster(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            case deleteCluster: {
                this.deleteCluster(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            case describeCluster: {
                this.describeCluster(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private MSK2Operations determineOperation(Exchange exchange) {
        MSK2Operations operation = (MSK2Operations)((Object)exchange.getIn().getHeader("CamelAwsMSKOperation", MSK2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected MSK2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.mskProducerToString == null) {
            this.mskProducerToString = "MSKProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.mskProducerToString;
    }

    public MSK2Endpoint getEndpoint() {
        return (MSK2Endpoint)super.getEndpoint();
    }

    private void listClusters(KafkaClient mskClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListClustersRequest) {
                ListClustersResponse result;
                try {
                    result = mskClient.listClusters((ListClustersRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Clusters command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MSK2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListClustersResponse result;
            ListClustersRequest.Builder builder = ListClustersRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterFilter"))) {
                String filter = (String)exchange.getIn().getHeader("CamelAwsMSKClusterFilter", String.class);
                builder.clusterNameFilter(filter);
            }
            try {
                result = mskClient.listClusters((ListClustersRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Clusters command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MSK2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createCluster(KafkaClient mskClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateClusterRequest) {
                CreateClusterResponse response;
                try {
                    response = mskClient.createCluster((CreateClusterRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MSK2Producer.getMessageForResponse(exchange);
                message.setBody((Object)response);
            }
        } else {
            CreateClusterResponse response;
            CreateClusterRequest.Builder builder = CreateClusterRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterName"))) {
                throw new IllegalArgumentException("Cluster Name must be specified");
            }
            String name = (String)exchange.getIn().getHeader("CamelAwsMSKClusterName", String.class);
            builder.clusterName(name);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterKafkaVersion"))) {
                throw new IllegalArgumentException("Kafka Version must be specified");
            }
            String version = (String)exchange.getIn().getHeader("CamelAwsMSKClusterKafkaVersion", String.class);
            builder.kafkaVersion(version);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesNumber"))) {
                throw new IllegalArgumentException("Kafka Version must be specified");
            }
            Integer nodesNumber = (Integer)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesNumber", Integer.class);
            builder.numberOfBrokerNodes(nodesNumber);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesGroupInfo"))) {
                throw new IllegalArgumentException("BrokerNodeGroupInfo must be specified");
            }
            BrokerNodeGroupInfo brokerNodesGroupInfo = (BrokerNodeGroupInfo)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesGroupInfo", BrokerNodeGroupInfo.class);
            builder.brokerNodeGroupInfo(brokerNodesGroupInfo);
            try {
                response = mskClient.createCluster((CreateClusterRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MSK2Producer.getMessageForResponse(exchange);
            message.setBody((Object)response);
        }
    }

    private void deleteCluster(KafkaClient mskClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteClusterRequest) {
                DeleteClusterResponse result;
                try {
                    result = mskClient.deleteCluster((DeleteClusterRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MSK2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteClusterResponse result;
            DeleteClusterRequest.Builder builder = DeleteClusterRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterArn"))) {
                throw new IllegalArgumentException("Cluster ARN must be specified");
            }
            String arn = (String)exchange.getIn().getHeader("CamelAwsMSKClusterArn", String.class);
            builder.clusterArn(arn);
            try {
                result = mskClient.deleteCluster((DeleteClusterRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MSK2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeCluster(KafkaClient mskClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeClusterRequest) {
                DescribeClusterResponse result;
                try {
                    result = mskClient.describeCluster((DescribeClusterRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MSK2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeClusterResponse result;
            DescribeClusterRequest.Builder builder = DescribeClusterRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterArn"))) {
                throw new IllegalArgumentException("Cluster ARN must be specified");
            }
            String arn = (String)exchange.getIn().getHeader("CamelAwsMSKClusterArn", String.class);
            builder.clusterArn(arn);
            try {
                result = mskClient.describeCluster((DescribeClusterRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MSK2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new MSK2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

