/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.redshift.data;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Configuration;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-redshift-data")
public class RedshiftData2Component
extends HealthCheckComponent {
    @Metadata
    private RedshiftData2Configuration configuration = new RedshiftData2Configuration();

    public RedshiftData2Component() {
        this(null);
    }

    public RedshiftData2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RedshiftData2Configuration configuration = this.configuration != null ? this.configuration.copy() : new RedshiftData2Configuration();
        RedshiftData2Endpoint endpoint = new RedshiftData2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && configuration.getAwsRedshiftDataClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, Amazon Redshift Data client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public RedshiftData2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RedshiftData2Configuration configuration) {
        this.configuration = configuration;
    }
}

