/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.redshift.data.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Configuration;
import org.apache.camel.component.aws2.redshift.data.client.RedshiftData2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class RedshiftData2ClientIAMOptimizedImpl
implements RedshiftData2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(RedshiftData2ClientIAMOptimizedImpl.class);
    private RedshiftData2Configuration configuration;

    public RedshiftData2ClientIAMOptimizedImpl(RedshiftData2Configuration configuration) {
        LOG.trace("Creating an AWS RedshiftData client for an ec2 instance with IAM temporary credentials (normal for ec2s).");
        this.configuration = configuration;
    }

    @Override
    public RedshiftDataClient getRedshiftDataClient() {
        RedshiftDataClient client = null;
        RedshiftDataClientBuilder clientBuilder = RedshiftDataClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            clientBuilder = (RedshiftDataClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (RedshiftDataClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (RedshiftDataClient)clientBuilder.build();
        return client;
    }
}

