/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3ConsumerHealthCheck;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.IoUtils;

public class AWS2S3Consumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3Consumer.class);
    private String marker;
    private transient String s3ConsumerToString;
    private WritableHealthCheckRepository healthCheckRepository;
    private AWS2S3ConsumerHealthCheck consumerHealthCheck;

    public AWS2S3Consumer(AWS2S3Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        block5: {
            super.doStart();
            this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"components", WritableHealthCheckRepository.class);
            if (this.healthCheckRepository != null) {
                this.consumerHealthCheck = new AWS2S3ConsumerHealthCheck(this, this.getRouteId());
                this.healthCheckRepository.addHealthCheck((HealthCheck)this.consumerHealthCheck);
            }
            if (this.getConfiguration().isMoveAfterRead()) {
                try {
                    this.getAmazonS3Client().headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.getConfiguration().getDestinationBucket()).build());
                    LOG.trace("Bucket [{}] already exists", (Object)this.getConfiguration().getDestinationBucket());
                    return;
                }
                catch (AwsServiceException ase) {
                    if (ase.awsErrorDetails().sdkHttpResponse().statusCode() != 404) {
                        throw ase;
                    }
                    LOG.trace("Destination Bucket [{}] doesn't exist yet", (Object)this.getConfiguration().getDestinationBucket());
                    if (!this.getConfiguration().isAutoCreateBucket()) break block5;
                    CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(this.getConfiguration().getDestinationBucket()).build();
                    LOG.trace("Creating Destination bucket [{}] in region [{}] with request [{}]...", new Object[]{this.getConfiguration().getDestinationBucket(), this.getConfiguration().getRegion(), createBucketRequest});
                    this.getAmazonS3Client().createBucket(createBucketRequest);
                    LOG.trace("Destination Bucket created");
                }
            }
        }
    }

    protected int poll() throws Exception {
        Queue<Object> exchanges;
        String doneFileName;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        String fileName = this.getConfiguration().getFileName();
        String bucketName = this.getConfiguration().getBucketName();
        if (!this.doneFileCheckPasses(bucketName, doneFileName = this.getConfiguration().getDoneFileName())) {
            exchanges = new LinkedList();
        } else if (fileName != null) {
            LOG.trace("Getting object in bucket [{}] with file name [{}]...", (Object)bucketName, (Object)fileName);
            ResponseInputStream s3Object = this.getAmazonS3Client().getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(fileName).build());
            exchanges = this.createExchanges((ResponseInputStream<GetObjectResponse>)s3Object, fileName);
        } else {
            ListObjectsResponse listObjects;
            LOG.trace("Queueing objects in bucket [{}]...", (Object)bucketName);
            ListObjectsRequest.Builder listObjectsRequest = ListObjectsRequest.builder();
            listObjectsRequest.bucket(bucketName);
            listObjectsRequest.prefix(this.getConfiguration().getPrefix());
            listObjectsRequest.delimiter(this.getConfiguration().getDelimiter());
            if (this.maxMessagesPerPoll > 0) {
                listObjectsRequest.maxKeys(Integer.valueOf(this.maxMessagesPerPoll));
            }
            if (this.marker != null) {
                LOG.trace("Resuming from marker: {}", (Object)this.marker);
                listObjectsRequest.marker(this.marker);
            }
            if ((listObjects = this.getAmazonS3Client().listObjects((ListObjectsRequest)listObjectsRequest.build())).isTruncated().booleanValue()) {
                this.marker = listObjects.nextMarker();
                LOG.trace("Returned list is truncated, so setting next marker: {}", (Object)this.marker);
            } else {
                this.marker = null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found {} objects in bucket [{}]...", (Object)listObjects.contents().size(), (Object)bucketName);
            }
            exchanges = this.createExchanges(listObjects.contents());
        }
        return this.processBatch(CastUtils.cast(exchanges));
    }

    private boolean doneFileCheckPasses(String bucketName, String doneFileName) {
        if (doneFileName == null) {
            return true;
        }
        return this.checkFileExists(bucketName, doneFileName);
    }

    private boolean checkFileExists(String bucketName, String doneFileName) {
        HeadObjectRequest.Builder headObjectsRequest = HeadObjectRequest.builder();
        headObjectsRequest.bucket(bucketName);
        headObjectsRequest.key(doneFileName);
        try {
            this.getAmazonS3Client().headObject((HeadObjectRequest)headObjectsRequest.build());
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    protected Queue<Exchange> createExchanges(ResponseInputStream<GetObjectResponse> s3Object, String key) {
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        Exchange exchange = this.createExchange(s3Object, key);
        answer.add(exchange);
        return answer;
    }

    protected Queue<Exchange> createExchanges(List<S3Object> s3ObjectSummaries) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received {} messages in this poll", (Object)s3ObjectSummaries.size());
        }
        ArrayList<ResponseInputStream> s3Objects = new ArrayList<ResponseInputStream>();
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        try {
            for (S3Object s3ObjectSummary : s3ObjectSummaries) {
                ResponseInputStream s3Object;
                GetObjectRequest.Builder getRequest = GetObjectRequest.builder().bucket(this.getConfiguration().getBucketName()).key(s3ObjectSummary.key());
                if (this.getConfiguration().isUseCustomerKey()) {
                    if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerKeyId())) {
                        getRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
                    }
                    if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerKeyMD5())) {
                        getRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
                    }
                    if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerAlgorithm())) {
                        getRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
                    }
                }
                if (this.includeS3Object((ResponseInputStream<GetObjectResponse>)(s3Object = (ResponseInputStream)this.getAmazonS3Client().getObject((GetObjectRequest)getRequest.build(), ResponseTransformer.toInputStream())))) {
                    s3Objects.add(s3Object);
                    Exchange exchange = this.createExchange((ResponseInputStream<GetObjectResponse>)s3Object, s3ObjectSummary.key());
                    answer.add(exchange);
                    continue;
                }
                IOHelper.close((Closeable)s3Object);
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting S3Object due: {}", (Object)e.getMessage(), (Object)e);
            s3Objects.forEach(IOHelper::close);
            throw e;
        }
        return answer;
    }

    protected boolean includeS3Object(ResponseInputStream<GetObjectResponse> s3Object) {
        if (this.getConfiguration().isIncludeFolders()) {
            return true;
        }
        return !Optional.of(((GetObjectResponse)s3Object.response()).contentType()).orElse("").toLowerCase().startsWith("application/x-directory");
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    AWS2S3Consumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    AWS2S3Consumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "S3ConsumerOnCompletion";
                }
            });
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            String key;
            String bucketName;
            if (this.getConfiguration().isMoveAfterRead()) {
                bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
                key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
                LOG.trace("Moving object from bucket {} with key {} to bucket {}...", new Object[]{bucketName, key, this.getConfiguration().getDestinationBucket()});
                StringBuilder builder = new StringBuilder();
                if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getDestinationBucketPrefix())) {
                    builder.append(this.getConfiguration().getDestinationBucketPrefix());
                }
                builder.append(key);
                if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getDestinationBucketSuffix())) {
                    builder.append(this.getConfiguration().getDestinationBucketSuffix());
                }
                this.getAmazonS3Client().copyObject((CopyObjectRequest)CopyObjectRequest.builder().destinationKey(builder.toString()).destinationBucket(this.getConfiguration().getDestinationBucket()).sourceBucket(bucketName).sourceKey(key).build());
                LOG.trace("Moved object from bucket {} with key {} to bucket {}...", new Object[]{bucketName, key, this.getConfiguration().getDestinationBucket()});
            }
            if (this.getConfiguration().isDeleteAfterRead()) {
                bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
                key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
                LOG.trace("Deleting object from bucket {} with key {}...", (Object)bucketName, (Object)key);
                this.getAmazonS3Client().deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.getConfiguration().getBucketName()).key(key).build());
                LOG.trace("Deleted object from bucket {} with key {}...", (Object)bucketName, (Object)key);
            }
        }
        catch (AwsServiceException e) {
            this.getExceptionHandler().handleException("Error occurred during moving or deleting object. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected S3Client getAmazonS3Client() {
        return this.getEndpoint().getS3Client();
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public Exchange createExchange(ResponseInputStream<GetObjectResponse> s3Object, String key) {
        return this.createExchange(this.getEndpoint().getExchangePattern(), s3Object, key);
    }

    public Exchange createExchange(ExchangePattern pattern, final ResponseInputStream<GetObjectResponse> s3Object, String key) {
        LOG.trace("Getting object with key [{}] from bucket [{}]...", (Object)key, (Object)this.getConfiguration().getBucketName());
        LOG.trace("Got object [{}]", s3Object);
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(pattern);
        Message message = exchange.getIn();
        if (!this.getConfiguration().isIgnoreBody()) {
            if (this.getConfiguration().isIncludeBody()) {
                try {
                    message.setBody((Object)IoUtils.toByteArray(s3Object));
                }
                catch (IOException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            } else {
                message.setBody(s3Object);
            }
        }
        message.setHeader("CamelAwsS3Key", (Object)key);
        message.setHeader("CamelAwsS3BucketName", (Object)this.getConfiguration().getBucketName());
        message.setHeader("CamelAwsS3ETag", (Object)((GetObjectResponse)s3Object.response()).eTag());
        message.setHeader("CamelAwsS3VersionId", (Object)((GetObjectResponse)s3Object.response()).versionId());
        message.setHeader("CamelAwsS3ContentType", (Object)((GetObjectResponse)s3Object.response()).contentType());
        message.setHeader("CamelAwsS3ContentLength", (Object)((GetObjectResponse)s3Object.response()).contentLength());
        message.setHeader("CamelAwsS3ContentEncoding", (Object)((GetObjectResponse)s3Object.response()).contentEncoding());
        message.setHeader("CamelAwsS3ContentDisposition", (Object)((GetObjectResponse)s3Object.response()).contentDisposition());
        message.setHeader("CamelAwsS3ContentControl", (Object)((GetObjectResponse)s3Object.response()).cacheControl());
        message.setHeader("CamelAwsS3ServerSideEncryption", (Object)((GetObjectResponse)s3Object.response()).serverSideEncryption());
        message.setHeader("CamelAwsS3ExpirationTime", (Object)((GetObjectResponse)s3Object.response()).expiration());
        message.setHeader("CamelAwsS3ReplicationStatus", (Object)((GetObjectResponse)s3Object.response()).replicationStatus());
        message.setHeader("CamelAwsS3StorageClass", (Object)((GetObjectResponse)s3Object.response()).storageClass());
        message.setHeader("CamelAwsS3Metadata", (Object)((GetObjectResponse)s3Object.response()).metadata());
        if (((GetObjectResponse)s3Object.response()).lastModified() != null) {
            message.setHeader("CamelAwsS3LastModified", (Object)((GetObjectResponse)s3Object.response()).lastModified());
            long ts = ((GetObjectResponse)s3Object.response()).lastModified().getEpochSecond() * 1000L;
            message.setHeader("CamelMessageTimestamp", (Object)ts);
        }
        if (this.getConfiguration().isIncludeBody()) {
            IOHelper.close(s3Object);
        } else if (this.getConfiguration().isAutocloseBody()) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    IOHelper.close((Closeable)s3Object);
                }
            });
        }
        return exchange;
    }

    public String toString() {
        if (this.s3ConsumerToString == null) {
            this.s3ConsumerToString = "S3Consumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ConsumerToString;
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.consumerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.consumerHealthCheck);
            this.consumerHealthCheck = null;
        }
        super.doStop();
    }
}

