/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.stream;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import org.apache.camel.component.aws2.s3.utils.AWS2S3Utils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.utils.IoUtils;

public class AWS2S3StreamUploadProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3StreamUploadProducer.class);
    private static final String TIMEOUT_CHECKER_EXECUTOR_NAME = "S3_Streaming_Upload_Timeout_Checker";
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    CreateMultipartUploadResponse initResponse;
    AtomicInteger index = new AtomicInteger(1);
    List<CompletedPart> completedParts;
    AtomicInteger part = new AtomicInteger();
    UUID id;
    String dynamicKeyName;
    CompleteMultipartUploadResponse uploadResult;
    private transient String s3ProducerToString;
    private ScheduledExecutorService timeoutCheckerExecutorService;

    public AWS2S3StreamUploadProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getConfiguration().getStreamingUploadTimeout() > 0L) {
            this.timeoutCheckerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, TIMEOUT_CHECKER_EXECUTOR_NAME);
            this.timeoutCheckerExecutorService.scheduleAtFixedRate(new StreamingUploadTimeoutTask(), this.getConfiguration().getStreamingUploadTimeout(), this.getConfiguration().getStreamingUploadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.getConfiguration().getRestartingPolicy().equals((Object)AWSS3RestartingPolicyEnum.lastPart)) {
            this.setStartingPart();
        }
    }

    protected void doStop() throws Exception {
        if (ObjectHelper.isNotEmpty((Object)this.initResponse) && ObjectHelper.isNotEmpty((String)this.initResponse.uploadId()) && this.index.get() > 0) {
            this.uploadPart();
            this.completeUpload();
        }
        if (this.timeoutCheckerExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        BucketCannedACL acl;
        String cannedAcl;
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        this.buffer.write(IoUtils.toByteArray((InputStream)is));
        String keyName = this.getConfiguration().getKeyName();
        String fileName = AWS2S3Utils.determineFileName(keyName);
        String extension = AWS2S3Utils.determineFileExtension(keyName);
        if (this.index.get() == 1 && this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.random)) {
            this.id = UUID.randomUUID();
        }
        this.dynamicKeyName = this.fileNameToUpload(fileName, this.getConfiguration().getNamingStrategy(), extension, this.part, this.id);
        CreateMultipartUploadRequest.Builder createMultipartUploadRequest = CreateMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(this.dynamicKeyName);
        String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
        if (storageClass != null) {
            createMultipartUploadRequest.storageClass(storageClass);
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
            createMultipartUploadRequest.acl(objectAcl);
        }
        if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
            createMultipartUploadRequest.acl(acl.toString());
        }
        AWS2S3Utils.setEncryption(createMultipartUploadRequest, this.getConfiguration());
        LOG.trace("Initiating multipart upload [{}] from exchange [{}]...", (Object)createMultipartUploadRequest, (Object)exchange);
        if (this.index.get() == 1) {
            this.initResponse = this.getEndpoint().getS3Client().createMultipartUpload((CreateMultipartUploadRequest)createMultipartUploadRequest.build());
            this.completedParts = new ArrayList<CompletedPart>();
        }
        try {
            if (this.buffer.size() >= this.getConfiguration().getBatchSize() || this.index.get() == this.getConfiguration().getBatchMessageNumber()) {
                this.uploadPart();
                this.completeUpload();
                Message message = AWS2S3StreamUploadProducer.getMessageForResponse(exchange);
                message.setHeader("CamelAwsS3ETag", (Object)this.uploadResult.eTag());
                if (this.uploadResult.versionId() != null) {
                    message.setHeader("CamelAwsS3VersionId", (Object)this.uploadResult.versionId());
                }
            }
        }
        catch (Exception e) {
            this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(this.dynamicKeyName).uploadId(this.initResponse.uploadId()).build());
            throw e;
        }
        this.index.getAndIncrement();
    }

    private void completeUpload() {
        CompletedMultipartUpload completeMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(this.completedParts).build();
        CompleteMultipartUploadRequest compRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().multipartUpload(completeMultipartUpload).bucket(this.getConfiguration().getBucketName()).key(this.dynamicKeyName).uploadId(this.initResponse.uploadId()).build();
        this.uploadResult = this.getEndpoint().getS3Client().completeMultipartUpload(compRequest);
        if (LOG.isInfoEnabled()) {
            LOG.info("Completed upload for the part {} with etag {} at index {}", new Object[]{this.part, this.uploadResult.eTag(), this.index});
        }
        this.index.getAndSet(0);
        this.initResponse = null;
    }

    private void uploadPart() {
        UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.getConfiguration().getBucketName()).key(this.dynamicKeyName).uploadId(this.initResponse.uploadId()).partNumber(Integer.valueOf(this.index.get())).build();
        LOG.trace("Uploading part {} at index {} for {}", new Object[]{this.part, this.index, this.getConfiguration().getKeyName()});
        String etag = this.getEndpoint().getS3Client().uploadPart(uploadRequest, RequestBody.fromBytes((byte[])this.buffer.toByteArray())).eTag();
        CompletedPart partUpload = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.index.get())).eTag(etag).build();
        this.completedParts.add(partUpload);
        this.buffer.reset();
        this.part.getAndIncrement();
    }

    private String fileNameToUpload(String fileName, AWSS3NamingStrategyEnum strategy, String ext, AtomicInteger part, UUID id) {
        Object dynamicKeyName;
        switch (strategy) {
            case progressive: {
                if (part.get() > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        dynamicKeyName = fileName + "-" + part + ext;
                        break;
                    }
                    dynamicKeyName = fileName + "-" + part;
                    break;
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    dynamicKeyName = fileName + ext;
                    break;
                }
                dynamicKeyName = fileName;
                break;
            }
            case random: {
                if (part.get() > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        dynamicKeyName = fileName + "-" + id.toString() + ext;
                        break;
                    }
                    dynamicKeyName = fileName + "-" + id.toString();
                    break;
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    dynamicKeyName = fileName + ext;
                    break;
                }
                dynamicKeyName = fileName;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
        return dynamicKeyName;
    }

    private void setStartingPart() {
        if (this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.progressive)) {
            ArrayList<S3Object> list = new ArrayList<S3Object>();
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.getConfiguration().getBucketName()).prefix(AWS2S3Utils.determineFileName(this.getConfiguration().getKeyName())).build();
            ListObjectsV2Iterable listRes = this.getEndpoint().getS3Client().listObjectsV2Paginator(request);
            listRes.stream().flatMap(r -> r.contents().stream()).forEach(content -> list.add((S3Object)content));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(S3Object::lastModified));
                int listSize = list.size();
                String fileName = AWS2S3Utils.determineFileName(((S3Object)list.get(listSize - 1)).key());
                int position = fileName.lastIndexOf("-");
                if (position != -1) {
                    String partString = fileName.substring(position + 1);
                    if (ObjectHelper.isNotEmpty((String)partString)) {
                        this.part.getAndSet(Integer.parseInt(partString) + 1);
                    }
                } else {
                    this.part.getAndSet(1);
                }
            }
        } else {
            LOG.info("lastPart restarting policy can be used only with progressive naming strategy");
        }
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.s3ProducerToString == null) {
            this.s3ProducerToString = "AWS2S3StreamUploadProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ProducerToString;
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private final class StreamingUploadTimeoutTask
    implements Runnable {
        private StreamingUploadTimeoutTask() {
        }

        @Override
        public void run() {
            if (ObjectHelper.isNotEmpty((Object)AWS2S3StreamUploadProducer.this.initResponse) && ObjectHelper.isNotEmpty((String)AWS2S3StreamUploadProducer.this.initResponse.uploadId()) && AWS2S3StreamUploadProducer.this.index.get() > 0) {
                AWS2S3StreamUploadProducer.this.uploadPart();
                AWS2S3StreamUploadProducer.this.completeUpload();
            }
        }
    }
}

