/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.client;

import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.client.AWS2CamelS3InternalClient;
import org.apache.camel.component.aws2.s3.client.impl.AWS2S3ClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.s3.client.impl.AWS2S3ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.s3.client.impl.AWS2S3ClientSessionTokenImpl;
import org.apache.camel.component.aws2.s3.client.impl.AWS2S3ClientStandardImpl;

public final class AWS2S3ClientFactory {
    private AWS2S3ClientFactory() {
    }

    public static AWS2CamelS3InternalClient getAWSS3Client(AWS2S3Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new AWS2S3ClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new AWS2S3ClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new AWS2S3ClientSessionTokenImpl(configuration);
        }
        return new AWS2S3ClientStandardImpl(configuration);
    }
}

