/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.ses.Ses2Component;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ses.SesClient;

public class Ses2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Ses2Configuration getOrCreateConfiguration(Ses2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Ses2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Ses2Component target = (Ses2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonsesclient": 
            case "amazonSESClient": {
                this.getOrCreateConfiguration(target).setAmazonSESClient((SesClient)Ses2ComponentConfigurer.property((CamelContext)camelContext, SesClient.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)Ses2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bcc": {
                this.getOrCreateConfiguration(target).setBcc((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cc": {
                this.getOrCreateConfiguration(target).setCc((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Ses2Configuration)Ses2ComponentConfigurer.property((CamelContext)camelContext, Ses2Configuration.class, (Object)value));
                return true;
            }
            case "configurationset": 
            case "configurationSet": {
                this.getOrCreateConfiguration(target).setConfigurationSet((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Ses2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)Ses2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Ses2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Ses2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytoaddresses": 
            case "replyToAddresses": {
                this.getOrCreateConfiguration(target).setReplyToAddresses((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "returnpath": 
            case "returnPath": {
                this.getOrCreateConfiguration(target).setReturnPath((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subject": {
                this.getOrCreateConfiguration(target).setSubject((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "to": {
                this.getOrCreateConfiguration(target).setTo((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)Ses2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)Ses2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseDefaultCredentialsProvider((Boolean)Ses2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"amazonSESClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "amazonsesclient": 
            case "amazonSESClient": {
                return SesClient.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bcc": {
                return String.class;
            }
            case "cc": {
                return String.class;
            }
            case "configuration": {
                return Ses2Configuration.class;
            }
            case "configurationset": 
            case "configurationSet": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "replytoaddresses": 
            case "replyToAddresses": {
                return String.class;
            }
            case "returnpath": 
            case "returnPath": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "subject": {
                return String.class;
            }
            case "to": {
                return String.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Ses2Component target = (Ses2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonsesclient": 
            case "amazonSESClient": {
                return this.getOrCreateConfiguration(target).getAmazonSESClient();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bcc": {
                return this.getOrCreateConfiguration(target).getBcc();
            }
            case "cc": {
                return this.getOrCreateConfiguration(target).getCc();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "configurationset": 
            case "configurationSet": {
                return this.getOrCreateConfiguration(target).getConfigurationSet();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "replytoaddresses": 
            case "replyToAddresses": {
                return this.getOrCreateConfiguration(target).getReplyToAddresses();
            }
            case "returnpath": 
            case "returnPath": {
                return this.getOrCreateConfiguration(target).getReturnPath();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "subject": {
                return this.getOrCreateConfiguration(target).getSubject();
            }
            case "to": {
                return this.getOrCreateConfiguration(target).getTo();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseDefaultCredentialsProvider();
            }
        }
        return null;
    }
}

