/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.Ses2Constants;
import org.apache.camel.component.aws2.ses.Ses2HealthCheck;
import org.apache.camel.component.aws2.ses.Ses2Producer;
import org.apache.camel.component.aws2.ses.client.Ses2ClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.ses.SesClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ses", title="AWS Simple Email Service (SES)", syntax="aws2-ses:from", producerOnly=true, category={Category.CLOUD, Category.MAIL}, headersClass=Ses2Constants.class)
public class Ses2Endpoint
extends DefaultEndpoint {
    private ComponentsHealthCheckRepository healthCheckRepository;
    private Ses2HealthCheck clientHealthCheck;
    private SesClient sesClient;
    @UriParam
    private Ses2Configuration configuration;

    public Ses2Endpoint(String uri, Component component, Ses2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.sesClient = this.configuration.getAmazonSESClient() != null ? this.configuration.getAmazonSESClient() : Ses2ClientFactory.getSesClient(this.configuration).getSesClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            // empty if block
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSESClient()) && this.sesClient != null) {
            this.sesClient.close();
        }
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        super.doStop();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Ses2Producer((Endpoint)this);
    }

    public Ses2Configuration getConfiguration() {
        return this.configuration;
    }

    public SesClient getSESClient() {
        return this.sesClient;
    }
}

