/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import org.apache.camel.spi.Metadata;

public interface Sqs2Constants {
    @Metadata(label="consumer", description="A map of the attributes requested in ReceiveMessage to their respective values.", javaType="Map<MessageSystemAttributeName, String>")
    public static final String ATTRIBUTES = "CamelAwsSqsAttributes";
    @Metadata(label="consumer", description="The Amazon SQS message attributes.", javaType="Map<String, MessageAttributeValue>")
    public static final String MESSAGE_ATTRIBUTES = "CamelAwsSqsMessageAttributes";
    @Metadata(description="The MD5 checksum of the Amazon SQS message.", javaType="String")
    public static final String MD5_OF_BODY = "CamelAwsSqsMD5OfBody";
    @Metadata(description="The Amazon SQS message ID.", javaType="String")
    public static final String MESSAGE_ID = "CamelAwsSqsMessageId";
    @Metadata(description="The Amazon SQS message receipt handle.", javaType="String")
    public static final String RECEIPT_HANDLE = "CamelAwsSqsReceiptHandle";
    @Metadata(label="producer", description="The delay seconds that the Amazon SQS message can be\nsee by others.", javaType="Integer")
    public static final String DELAY_HEADER = "CamelAwsSqsDelaySeconds";
    public static final String MESSAGE_GROUP_ID_PROPERTY = "CamelAwsMessageGroupId";
    @Metadata(description="A string to use for filtering the list results.", javaType="String")
    public static final String SQS_QUEUE_PREFIX = "CamelAwsSqsPrefix";
    @Metadata(description="The operation we want to perform", javaType="String")
    public static final String SQS_OPERATION = "CamelAwsSqsOperation";
    public static final String SQS_DELETE_FILTERED = "CamelAwsSqsDeleteFiltered";
    @Metadata(label="listQueues", description="The token for the next set of results.", javaType="String")
    public static final String NEXT_TOKEN = "CamelAwsSqsNextToken";
    @Metadata(label="listQueues", description="The maximum number of results to return.", javaType="Integer")
    public static final String MAX_RESULTS = "CamelAwsSqsMaxResults";
    @Metadata(label="listQueues", description="Whether the response has more results (is truncated).", javaType="Boolean")
    public static final String IS_TRUNCATED = "CamelAwsSqsIsTruncated";
    @Metadata(label="producer", description="The sequence number for FIFO queues.", javaType="String")
    public static final String SEQUENCE_NUMBER = "CamelAwsSqsSequenceNumber";
    @Metadata(label="sendBatchMessage", description="The number of failed messages in a batch send operation.", javaType="Integer")
    public static final String FAILED_MESSAGE_COUNT = "CamelAwsSqsFailedMessageCount";
    @Metadata(label="sendBatchMessage", description="The number of successful messages in a batch send operation.", javaType="Integer")
    public static final String SUCCESSFUL_MESSAGE_COUNT = "CamelAwsSqsSuccessfulMessageCount";
}

