/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.sqs.MessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sqs.MessageGroupIdStrategy;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Endpoint;
import org.apache.camel.component.aws2.sqs.Sqs2MessageHelper;
import org.apache.camel.component.aws2.sqs.Sqs2Operations;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class Sqs2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2Producer.class);
    private static final int MAX_ATTRIBUTES = 10;
    private static final String MAX_MESSAGE = "Number of message headers exceeded. At most 10 headers is allowed when sending to AWS SQS.";
    private transient String sqsProducerToString;

    public Sqs2Producer(Sqs2Endpoint endpoint) {
        super((Endpoint)endpoint);
        if (endpoint.getConfiguration().isFifoQueue() && ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getMessageGroupIdStrategy())) {
            throw new IllegalArgumentException("messageGroupIdStrategy must be set for FIFO queues.");
        }
    }

    public void process(Exchange exchange) throws Exception {
        Sqs2Operations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            this.processSingleMessage(exchange);
        } else {
            switch (operation) {
                case sendBatchMessage: {
                    this.sendBatchMessage(this.getClient(), exchange);
                    break;
                }
                case deleteMessage: {
                    this.deleteMessage(this.getClient(), exchange);
                    break;
                }
                case listQueues: {
                    this.listQueues(this.getClient(), exchange);
                    break;
                }
                case purgeQueue: {
                    this.purgeQueue(this.getClient(), exchange);
                    break;
                }
                case deleteQueue: {
                    this.deleteQueue(this.getClient(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void processSingleMessage(Exchange exchange) {
        String body = (String)exchange.getIn().getBody(String.class);
        SendMessageRequest.Builder request = SendMessageRequest.builder().queueUrl(this.getQueueUrl()).messageBody(body);
        request.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
        this.addDelay(request, exchange);
        this.configureFifoAttributes(request, exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        SendMessageResponse result = this.getClient().sendMessage((SendMessageRequest)request.build());
        LOG.trace("Received result [{}]", (Object)result);
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSqsMessageId", (Object)result.messageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)result.md5OfMessageBody());
        message.setHeader("CamelAwsSqsSequenceNumber", (Object)result.sequenceNumber());
    }

    private void sendBatchMessage(SqsClient amazonSQS, Exchange exchange) {
        SendMessageBatchRequest.Builder request = SendMessageBatchRequest.builder().queueUrl(this.getQueueUrl());
        ArrayList<SendMessageBatchRequestEntry> entries = new ArrayList<SendMessageBatchRequestEntry>();
        if (exchange.getIn().getBody() instanceof Iterable) {
            Iterable c = (Iterable)exchange.getIn().getBody(Iterable.class);
            for (Object o : c) {
                String object = (String)o;
                SendMessageBatchRequestEntry.Builder entry = SendMessageBatchRequestEntry.builder();
                entry.id(UUID.randomUUID().toString());
                entry.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
                entry.messageBody(object);
                this.addDelay(entry, exchange);
                this.configureFifoAttributes(entry, exchange);
                entries.add((SendMessageBatchRequestEntry)entry.build());
            }
            request.entries(entries);
            SendMessageBatchResponse result = amazonSQS.sendMessageBatch((SendMessageBatchRequest)request.build());
            Message message = Sqs2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsSqsFailedMessageCount", (Object)(ObjectHelper.isNotEmpty((Collection)result.failed()) ? result.failed().size() : 0));
            message.setHeader("CamelAwsSqsSuccessfulMessageCount", (Object)(ObjectHelper.isNotEmpty((Collection)result.successful()) ? result.successful().size() : 0));
        } else if (exchange.getIn().getBody() instanceof String) {
            String[] elements;
            String c = (String)exchange.getIn().getBody(String.class);
            for (String o : elements = c.split(this.getConfiguration().getBatchSeparator())) {
                SendMessageBatchRequestEntry.Builder entry = SendMessageBatchRequestEntry.builder();
                entry.id(UUID.randomUUID().toString());
                entry.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
                entry.messageBody(o);
                this.addDelay(entry, exchange);
                this.configureFifoAttributes(entry, exchange);
                entries.add((SendMessageBatchRequestEntry)entry.build());
            }
            request.entries(entries);
            SendMessageBatchResponse result = amazonSQS.sendMessageBatch((SendMessageBatchRequest)request.build());
            Message message = Sqs2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsSqsFailedMessageCount", (Object)(ObjectHelper.isNotEmpty((Collection)result.failed()) ? result.failed().size() : 0));
            message.setHeader("CamelAwsSqsSuccessfulMessageCount", (Object)(ObjectHelper.isNotEmpty((Collection)result.successful()) ? result.successful().size() : 0));
        } else {
            SendMessageBatchRequest req = (SendMessageBatchRequest)exchange.getIn().getBody(SendMessageBatchRequest.class);
            SendMessageBatchResponse result = amazonSQS.sendMessageBatch(req);
            Message message = Sqs2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsSqsFailedMessageCount", (Object)(ObjectHelper.isNotEmpty((Collection)result.failed()) ? result.failed().size() : 0));
            message.setHeader("CamelAwsSqsSuccessfulMessageCount", (Object)(ObjectHelper.isNotEmpty((Collection)result.successful()) ? result.successful().size() : 0));
        }
    }

    private void deleteMessage(SqsClient amazonSQS, Exchange exchange) {
        String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
        DeleteMessageRequest.Builder request = DeleteMessageRequest.builder();
        request.queueUrl(this.getQueueUrl());
        if (ObjectHelper.isEmpty((String)receiptHandle)) {
            throw new IllegalArgumentException("Receipt Handle must be specified for the operation deleteMessage");
        }
        request.receiptHandle(receiptHandle);
        DeleteMessageResponse result = amazonSQS.deleteMessage((DeleteMessageRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listQueues(SqsClient amazonSQS, Exchange exchange) {
        Integer maxResults;
        String nextToken;
        ListQueuesRequest.Builder request = ListQueuesRequest.builder();
        String prefix = (String)exchange.getIn().getHeader("CamelAwsSqsPrefix", String.class);
        if (ObjectHelper.isNotEmpty((String)prefix)) {
            request.queueNamePrefix(prefix);
        }
        if (ObjectHelper.isNotEmpty((String)(nextToken = (String)exchange.getIn().getHeader("CamelAwsSqsNextToken", String.class)))) {
            request.nextToken(nextToken);
        }
        if (ObjectHelper.isNotEmpty((Object)(maxResults = (Integer)exchange.getIn().getHeader("CamelAwsSqsMaxResults", Integer.class)))) {
            request.maxResults(maxResults);
        }
        ListQueuesResponse result = amazonSQS.listQueues((ListQueuesRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
        message.setHeader("CamelAwsSqsNextToken", (Object)result.nextToken());
        message.setHeader("CamelAwsSqsIsTruncated", (Object)ObjectHelper.isNotEmpty((String)result.nextToken()));
    }

    private void purgeQueue(SqsClient amazonSQS, Exchange exchange) {
        PurgeQueueRequest.Builder request = PurgeQueueRequest.builder();
        request.queueUrl(this.getQueueUrl());
        PurgeQueueResponse result = amazonSQS.purgeQueue((PurgeQueueRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteQueue(SqsClient amazonSQS, Exchange exchange) {
        DeleteQueueRequest.Builder request = DeleteQueueRequest.builder();
        request.queueUrl(this.getQueueUrl());
        DeleteQueueResponse result = amazonSQS.deleteQueue((DeleteQueueRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void configureFifoAttributes(SendMessageRequest.Builder request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoQueue()) {
            if (ObjectHelper.isNotEmpty((Object)this.getEndpoint().getConfiguration().getMessageGroupIdStrategy())) {
                MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
                String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
                request.messageGroupId(messageGroupId);
            }
            if (ObjectHelper.isNotEmpty((Object)this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy())) {
                MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
                String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
                request.messageDeduplicationId(messageDeduplicationId);
            }
        }
    }

    private void configureFifoAttributes(SendMessageBatchRequestEntry.Builder request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoQueue()) {
            MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
            String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
            request.messageGroupId(messageGroupId);
            MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
            String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
            request.messageDeduplicationId(messageDeduplicationId);
        }
    }

    private void addDelay(SendMessageRequest.Builder request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (ObjectHelper.isEmpty((Object)headerValue)) {
            LOG.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            LOG.trace("Using the header delay");
            delayValue = headerValue;
        }
        LOG.trace("found delay: {}", (Object)delayValue);
        if (ObjectHelper.isNotEmpty((Object)delayValue)) {
            request.delaySeconds(delayValue);
        }
    }

    private void addDelay(SendMessageBatchRequestEntry.Builder request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (ObjectHelper.isEmpty((Object)headerValue)) {
            LOG.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            LOG.trace("Using the header delay");
            delayValue = headerValue;
        }
        LOG.trace("found delay: {}", (Object)delayValue);
        if (ObjectHelper.isNotEmpty((Object)delayValue)) {
            request.delaySeconds(delayValue);
        }
    }

    protected SqsClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    protected Sqs2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Sqs2Endpoint getEndpoint() {
        return (Sqs2Endpoint)super.getEndpoint();
    }

    public String toString() {
        if (ObjectHelper.isEmpty((String)this.sqsProducerToString)) {
            this.sqsProducerToString = "SqsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sqsProducerToString;
    }

    Map<String, MessageAttributeValue> translateAttributes(Map<String, Object> headers, Exchange exchange) {
        HashMap<String, MessageAttributeValue> result = new HashMap<String, MessageAttributeValue>();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            if (result.size() < 10) {
                MessageAttributeValue mav = Sqs2MessageHelper.toMessageAttributeValue(entry.getValue());
                if (!ObjectHelper.isNotEmpty((Object)mav)) continue;
                result.put(entry.getKey(), mav);
                continue;
            }
            String action = this.getConfiguration().getMessageHeaderExceededLimit();
            if ("WARN".equalsIgnoreCase(action) || "WARN_ONCE".equalsIgnoreCase(action)) {
                LOG.warn("Cannot put message header with key={} due: {}", (Object)entry.getKey(), (Object)MAX_MESSAGE);
                if (!"WARN_ONCE".equalsIgnoreCase(action)) continue;
                break;
            }
            if ("IGNORE".equalsIgnoreCase(action)) break;
            if (!"FAIL".equalsIgnoreCase(action)) continue;
            throw new IllegalArgumentException(MAX_MESSAGE);
        }
        return result;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private Sqs2Operations determineOperation(Exchange exchange) {
        Sqs2Operations operation = (Sqs2Operations)((Object)exchange.getIn().getHeader("CamelAwsSqsOperation", Sqs2Operations.class));
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

