/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs.client;

import java.net.URI;
import org.apache.camel.component.aws.common.AwsClientBuilderUtil;
import org.apache.camel.component.aws.common.AwsCommonConfiguration;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.util.FileUtil;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;

public final class Sqs2ClientFactory {
    private static final String DEFAULT_AWS_HOST = "amazonaws.com";

    private Sqs2ClientFactory() {
    }

    public static SqsClient getSqsClient(Sqs2Configuration configuration) {
        return (SqsClient)AwsClientBuilderUtil.buildClient((AwsCommonConfiguration)configuration, SqsClient::builder, builder -> {
            if (!Sqs2ClientFactory.isDefaultAwsHost(configuration) && !configuration.isOverrideEndpoint()) {
                String endpointOverrideUri = Sqs2ClientFactory.getAwsEndpointUri(configuration);
                builder.endpointOverride(URI.create(endpointOverrideUri));
            }
        });
    }

    private static boolean isDefaultAwsHost(Sqs2Configuration configuration) {
        return DEFAULT_AWS_HOST.equals(configuration.getAmazonAWSHost());
    }

    private static String getAwsEndpointUri(Sqs2Configuration configuration) {
        return configuration.getProtocol() + "://" + Sqs2ClientFactory.getFullyQualifiedAWSHost(configuration);
    }

    private static String getFullyQualifiedAWSHost(Sqs2Configuration configuration) {
        String host = configuration.getAmazonAWSHost();
        host = FileUtil.stripTrailingSeparator((String)host);
        if (Sqs2ClientFactory.isDefaultAwsHost(configuration)) {
            return "sqs." + Region.of((String)configuration.getRegion()).id() + "." + host;
        }
        return host;
    }
}

