/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws2-sqs:application-cloudevents")
public class AWS2SQSCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.aws.sqs.receiveMessage");
        if (message.getHeaders().containsKey("CamelAwsSqsReceiptHandle")) {
            headers.put("CamelCloudEventSource", "aws.sqs.queue." + (String)message.getHeader("CamelAwsSqsReceiptHandle", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAwsSqsMessageId", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
    }
}

