/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sts;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.sts.STS2ComponentVerifierExtension;
import org.apache.camel.component.aws2.sts.STS2Configuration;
import org.apache.camel.component.aws2.sts.STS2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-sts")
public class STS2Component
extends DefaultComponent {
    @Metadata
    private STS2Configuration configuration = new STS2Configuration();

    public STS2Component() {
        this(null);
    }

    public STS2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new STS2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        STS2Configuration configurationClone = this.configuration != null ? this.configuration.copy() : new STS2Configuration();
        STS2Endpoint endpoint = new STS2Endpoint(uri, (Component)this, configurationClone);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configurationClone.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configurationClone.isUseProfileCredentialsProvider()) && configurationClone.getStsClient() == null && (configurationClone.getAccessKey() == null || configurationClone.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, Amazon STS client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public STS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(STS2Configuration configuration) {
        this.configuration = configuration;
    }
}

