/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream.query;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.Timestream2Operations;
import org.apache.camel.component.aws2.timestream.query.Timestream2QueryEndpoint;
import org.apache.camel.component.aws2.timestream.query.Timestream2QueryProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings;
import software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.S3Configuration;
import software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryResponse;

public class Timestream2QueryProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Timestream2QueryProducer.class);
    private transient String timestreamQueryProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public Timestream2QueryProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case describeEndpoints: {
                this.describeEndpoints(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case createScheduledQuery: {
                this.createScheduledQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case deleteScheduledQuery: {
                this.deleteScheduledQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case executeScheduledQuery: {
                this.executeScheduledQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case updateScheduledQuery: {
                this.updateScheduledQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case describeScheduledQuery: {
                this.describeScheduledQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case listScheduledQueries: {
                this.listScheduledQueries(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case prepareQuery: {
                this.prepareQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case query: {
                this.query(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            case cancelQuery: {
                this.cancelQuery(this.getEndpoint().getAwsTimestreamQueryClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private Timestream2Operations determineOperation(Exchange exchange) {
        Timestream2Operations operation = (Timestream2Operations)((Object)exchange.getIn().getHeader("CamelAwsTimestreamOperation", Timestream2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected Timestream2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.timestreamQueryProducerToString == null) {
            this.timestreamQueryProducerToString = "TimestreamQueryProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.timestreamQueryProducerToString;
    }

    public Timestream2QueryEndpoint getEndpoint() {
        return (Timestream2QueryEndpoint)super.getEndpoint();
    }

    private void describeEndpoints(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeEndpointsRequest) {
                DescribeEndpointsResponse result;
                DescribeEndpointsRequest request = (DescribeEndpointsRequest)payload;
                try {
                    result = timestreamQueryClient.describeEndpoints(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Endpoints command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeEndpointsResponse result;
            DescribeEndpointsRequest.Builder builder = DescribeEndpointsRequest.builder();
            try {
                result = timestreamQueryClient.describeEndpoints((DescribeEndpointsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Endpoints command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createScheduledQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateScheduledQueryRequest) {
                CreateScheduledQueryResponse result;
                CreateScheduledQueryRequest request = (CreateScheduledQueryRequest)payload;
                try {
                    result = timestreamQueryClient.createScheduledQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateScheduledQueryResponse result;
            String roleArn;
            CreateScheduledQueryRequest.Builder builder = CreateScheduledQueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryName"))) {
                String name = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryName", String.class);
                builder.name(name);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamQueryString"))) {
                String queryString = (String)exchange.getIn().getHeader("CamelAwsTimestreamQueryString", String.class);
                builder.queryString(queryString);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduleExpression"))) {
                String scheduleExp = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduleExpression", String.class);
                builder.scheduleConfiguration((ScheduleConfiguration)ScheduleConfiguration.builder().scheduleExpression(scheduleExp).build());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamNotificationTopicArn"))) {
                String topicArn = (String)exchange.getIn().getHeader("CamelAwsTimestreamNotificationTopicArn", String.class);
                SnsConfiguration snsConfiguration = (SnsConfiguration)SnsConfiguration.builder().topicArn(topicArn).build();
                builder.notificationConfiguration((NotificationConfiguration)NotificationConfiguration.builder().snsConfiguration(snsConfiguration).build());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamKmsKeyId"))) {
                String kmsKeyId = (String)exchange.getIn().getHeader("CamelAwsTimestreamKmsKeyId", String.class);
                builder.kmsKeyId(kmsKeyId);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamClientToken"))) {
                String clientToken = (String)exchange.getIn().getHeader("CamelAwsTimestreamClientToken", String.class);
                builder.clientToken(clientToken);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryExecutionRoleArn"))) {
                roleArn = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryExecutionRoleArn", String.class);
                builder.scheduledQueryExecutionRoleArn(roleArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamErrorReportS3BucketName"))) {
                String s3BucketName = (String)exchange.getIn().getHeader("CamelAwsTimestreamErrorReportS3BucketName", String.class);
                S3Configuration.Builder s3Configuration = S3Configuration.builder().bucketName(s3BucketName);
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamErrorReportS3ObjectKeyPrefix"))) {
                    String objectKeyPrefix = (String)exchange.getIn().getHeader("CamelAwsTimestreamErrorReportS3ObjectKeyPrefix", String.class);
                    s3Configuration.objectKeyPrefix(objectKeyPrefix);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamErrorReportS3EncryptionOption"))) {
                    String encryptionOption = (String)exchange.getIn().getHeader("CamelAwsTimestreamErrorReportS3EncryptionOption", String.class);
                    s3Configuration.encryptionOption(encryptionOption);
                }
                ErrorReportConfiguration errorReportConfiguration = (ErrorReportConfiguration)ErrorReportConfiguration.builder().s3Configuration((S3Configuration)s3Configuration.build()).build();
                builder.errorReportConfiguration(errorReportConfiguration);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryExecutionRoleArn"))) {
                roleArn = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryExecutionRoleArn", String.class);
                builder.scheduledQueryExecutionRoleArn(roleArn);
            }
            TargetConfiguration.Builder targetConfiguration = TargetConfiguration.builder();
            TimestreamConfiguration.Builder timestreamConfigBuilder = TimestreamConfiguration.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                timestreamConfigBuilder.databaseName(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableName"))) {
                String table = (String)exchange.getIn().getHeader("CamelAwsTimestreamTableName", String.class);
                timestreamConfigBuilder.tableName(table);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTimeColumn"))) {
                String timeColumn = (String)exchange.getIn().getHeader("CamelAwsTimestreamTimeColumn", String.class);
                timestreamConfigBuilder.tableName(timeColumn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMeasureColumnName"))) {
                String measureNameColumn = (String)exchange.getIn().getHeader("CamelAwsTimestreamMeasureColumnName", String.class);
                timestreamConfigBuilder.measureNameColumn(measureNameColumn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDimensionMappingList"))) {
                List dimensionMappingList = (List)exchange.getIn().getHeader("CamelAwsTimestreamDimensionMappingList", List.class);
                timestreamConfigBuilder.dimensionMappings((Collection)dimensionMappingList);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMultiMeasureMappings"))) {
                MultiMeasureMappings multiMeasureMappings = (MultiMeasureMappings)exchange.getIn().getHeader("CamelAwsTimestreamMultiMeasureMappings", MultiMeasureMappings.class);
                timestreamConfigBuilder.multiMeasureMappings(multiMeasureMappings);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMixedMeasureMappingList"))) {
                List mixedMeasureMappings = (List)exchange.getIn().getHeader("CamelAwsTimestreamMixedMeasureMappingList", List.class);
                timestreamConfigBuilder.mixedMeasureMappings((Collection)mixedMeasureMappings);
            }
            targetConfiguration.timestreamConfiguration((TimestreamConfiguration)timestreamConfigBuilder.build());
            builder.targetConfiguration((TargetConfiguration)targetConfiguration.build());
            try {
                result = timestreamQueryClient.createScheduledQuery((CreateScheduledQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteScheduledQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteScheduledQueryRequest) {
                DeleteScheduledQueryResponse result;
                DeleteScheduledQueryRequest request = (DeleteScheduledQueryRequest)payload;
                try {
                    result = timestreamQueryClient.deleteScheduledQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteScheduledQueryResponse result;
            DeleteScheduledQueryRequest.Builder builder = DeleteScheduledQueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryArn"))) {
                String queryArn = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryArn", String.class);
                builder.scheduledQueryArn(queryArn);
            }
            try {
                result = timestreamQueryClient.deleteScheduledQuery((DeleteScheduledQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void executeScheduledQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ExecuteScheduledQueryRequest) {
                ExecuteScheduledQueryResponse result;
                ExecuteScheduledQueryRequest request = (ExecuteScheduledQueryRequest)payload;
                try {
                    result = timestreamQueryClient.executeScheduledQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Execute Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ExecuteScheduledQueryResponse result;
            ExecuteScheduledQueryRequest.Builder builder = ExecuteScheduledQueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryArn"))) {
                String queryArn = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryArn", String.class);
                builder.scheduledQueryArn(queryArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamClientToken"))) {
                String clientToken = (String)exchange.getIn().getHeader("CamelAwsTimestreamClientToken", String.class);
                builder.clientToken(clientToken);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryInvocationTime"))) {
                Instant invocationTime = (Instant)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryInvocationTime", Instant.class);
                builder.invocationTime(invocationTime);
            }
            try {
                result = timestreamQueryClient.executeScheduledQuery((ExecuteScheduledQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Execute Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateScheduledQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateScheduledQueryRequest) {
                UpdateScheduledQueryResponse result;
                UpdateScheduledQueryRequest request = (UpdateScheduledQueryRequest)payload;
                try {
                    result = timestreamQueryClient.updateScheduledQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Update Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateScheduledQueryResponse result;
            UpdateScheduledQueryRequest.Builder builder = UpdateScheduledQueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryArn"))) {
                String queryArn = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryArn", String.class);
                builder.scheduledQueryArn(queryArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryState"))) {
                String state = (String)exchange.getIn().getHeader("CamelAwsTimestreamScheduledQueryState", String.class);
                builder.state(state);
            }
            try {
                result = timestreamQueryClient.updateScheduledQuery((UpdateScheduledQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Update Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeScheduledQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeScheduledQueryRequest) {
                DescribeScheduledQueryResponse result;
                DescribeScheduledQueryRequest request = (DescribeScheduledQueryRequest)payload;
                try {
                    result = timestreamQueryClient.describeScheduledQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeScheduledQueryResponse result;
            DescribeScheduledQueryRequest.Builder builder = DescribeScheduledQueryRequest.builder();
            try {
                result = timestreamQueryClient.describeScheduledQuery((DescribeScheduledQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Scheduled Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listScheduledQueries(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListScheduledQueriesRequest) {
                ListScheduledQueriesResponse result;
                ListScheduledQueriesRequest request = (ListScheduledQueriesRequest)payload;
                try {
                    result = timestreamQueryClient.listScheduledQueries(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Scheduled Queries command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListScheduledQueriesResponse result;
            ListScheduledQueriesRequest.Builder builder = ListScheduledQueriesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            try {
                result = timestreamQueryClient.listScheduledQueries((ListScheduledQueriesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Scheduled Queries command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void prepareQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PrepareQueryRequest) {
                PrepareQueryResponse result;
                PrepareQueryRequest request = (PrepareQueryRequest)payload;
                try {
                    result = timestreamQueryClient.prepareQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Prepare Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            PrepareQueryResponse result;
            PrepareQueryRequest.Builder builder = PrepareQueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamQueryString"))) {
                String queryString = (String)exchange.getIn().getHeader("CamelAwsTimestreamQueryString", String.class);
                builder.queryString(queryString);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamQueryValidateOnly"))) {
                Boolean validateFlag = (Boolean)exchange.getIn().getHeader("CamelAwsTimestreamQueryValidateOnly", Boolean.class);
                builder.validateOnly(validateFlag);
            }
            try {
                result = timestreamQueryClient.prepareQuery((PrepareQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Prepare Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void query(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof QueryRequest) {
                QueryResponse result;
                QueryRequest request = (QueryRequest)payload;
                try {
                    result = timestreamQueryClient.query(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            QueryResponse result;
            QueryRequest.Builder builder = QueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamQueryString"))) {
                String queryString = (String)exchange.getIn().getHeader("CamelAwsTimestreamQueryString", String.class);
                builder.queryString(queryString);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamQueryMaxRows"))) {
                Integer maxRows = (Integer)exchange.getIn().getHeader("CamelAwsTimestreamQueryMaxRows", Integer.class);
                builder.maxRows(maxRows);
            }
            try {
                result = timestreamQueryClient.query((QueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void cancelQuery(TimestreamQueryClient timestreamQueryClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CancelQueryRequest) {
                CancelQueryResponse result;
                CancelQueryRequest request = (CancelQueryRequest)payload;
                try {
                    result = timestreamQueryClient.cancelQuery(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Cancel Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CancelQueryResponse result;
            CancelQueryRequest.Builder builder = CancelQueryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamQueryId"))) {
                String queryId = (String)exchange.getIn().getHeader("CamelAwsTimestreamQueryId", String.class);
                builder.queryId(queryId);
            }
            try {
                result = timestreamQueryClient.cancelQuery((CancelQueryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Cancel Query command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2QueryProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new Timestream2QueryProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

