/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.client.Timestream2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClientBuilder;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class Timestream2ClientIAMOptimizedImpl
implements Timestream2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(Timestream2ClientIAMOptimizedImpl.class);
    private Timestream2Configuration configuration;

    public Timestream2ClientIAMOptimizedImpl(Timestream2Configuration configuration) {
        LOG.trace("Creating an AWS Timestream client for an ec2 instance with IAM temporary credentials (normal for ec2s).");
        this.configuration = configuration;
    }

    @Override
    public TimestreamWriteClient getTimestreamWriteClient() {
        TimestreamWriteClient client = null;
        TimestreamWriteClientBuilder clientBuilder = TimestreamWriteClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            clientBuilder = (TimestreamWriteClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (TimestreamWriteClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (TimestreamWriteClient)clientBuilder.build();
        return client;
    }

    @Override
    public TimestreamQueryClient getTimestreamQueryClient() {
        TimestreamQueryClient client = null;
        TimestreamQueryClientBuilder clientBuilder = TimestreamQueryClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            clientBuilder = (TimestreamQueryClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (TimestreamQueryClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (TimestreamQueryClient)clientBuilder.build();
        return client;
    }
}

