/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import com.azure.cosmos.CosmosAsyncClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConsumer;
import org.apache.camel.component.azure.cosmosdb.CosmosDbProducer;
import org.apache.camel.component.azure.cosmosdb.client.CosmosDbClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.10.0", scheme="azure-cosmosdb", title="Azure CosmosDB", syntax="azure-cosmosdb:databaseName/containerName", category={Category.CLOUD, Category.DATABASE})
public class CosmosDbEndpoint
extends DefaultEndpoint {
    @UriParam
    private CosmosDbConfiguration configuration;
    private CosmosAsyncClient cosmosAsyncClient;

    public CosmosDbEndpoint(String uri, Component component, CosmosDbConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new CosmosDbProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getDatabaseName()) || ObjectHelper.isEmpty((Object)this.configuration.getContainerName())) {
            throw new IllegalArgumentException("Database name and container name must be set.");
        }
        CosmosDbConsumer cosmosDbConsumer = new CosmosDbConsumer(this, processor);
        this.configureConsumer((Consumer)cosmosDbConsumer);
        return cosmosDbConsumer;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.cosmosAsyncClient = this.configuration.getCosmosAsyncClient() != null ? this.configuration.getCosmosAsyncClient() : CosmosDbClientFactory.createCosmosAsyncClient(this.configuration);
    }

    public void doStop() throws Exception {
        if (this.cosmosAsyncClient != null) {
            this.cosmosAsyncClient.close();
        }
        super.doStop();
    }

    public CosmosDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CosmosDbConfiguration configuration) {
        this.configuration = configuration;
    }

    public CosmosAsyncClient getCosmosAsyncClient() {
        return this.cosmosAsyncClient;
    }

    public void setCosmosAsyncClient(CosmosAsyncClient cosmosAsyncClient) {
        this.cosmosAsyncClient = cosmosAsyncClient;
    }
}

