/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.client;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;

public final class CosmosDbClientFactory {
    private CosmosDbClientFactory() {
    }

    public static CosmosAsyncClient createCosmosAsyncClient(CosmosDbConfiguration configuration) {
        return CosmosDbClientFactory.createBasicClient(configuration).buildAsyncClient();
    }

    public static CosmosClient createCosmosSyncClient(CosmosDbConfiguration configuration) {
        return CosmosDbClientFactory.createBasicClient(configuration).buildClient();
    }

    private static CosmosClientBuilder createBasicClient(CosmosDbConfiguration configuration) {
        return new CosmosClientBuilder().key(configuration.getAccountKey()).endpoint(configuration.getDatabaseEndpoint()).contentResponseOnWriteEnabled(configuration.isContentResponseOnWriteEnabled()).consistencyLevel(configuration.getConsistencyLevel()).preferredRegions(configuration.getPreferredRegions()).connectionSharingAcrossClientsEnabled(configuration.isConnectionSharingAcrossClientsEnabled()).clientTelemetryEnabled(configuration.isClientTelemetryEnabled()).multipleWriteRegionsEnabled(configuration.isMultipleWriteRegionsEnabled()).readRequestsFallbackEnabled(configuration.isReadRequestsFallbackEnabled());
    }
}

