/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ThroughputProperties;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class CosmosDbConfiguration
implements Cloneable {
    @UriPath
    private String databaseName;
    @UriPath
    private String containerName;
    @UriParam(label="security", secret=true)
    @Metadata(required=false)
    private String accountKey;
    @UriParam(label="security", secret=false)
    @Metadata(required=false)
    private boolean useDefaultIdentity;
    @UriParam(label="common")
    @Metadata(required=true)
    private String databaseEndpoint;
    @UriParam(label="common")
    private String containerPartitionKeyPath;
    @UriParam(label="common")
    @Metadata(autowired=true)
    private CosmosAsyncClient cosmosAsyncClient;
    @UriParam(label="common", defaultValue="SESSION")
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.SESSION;
    @UriParam(label="common")
    private String preferredRegions;
    @UriParam(label="common", defaultValue="false")
    private boolean clientTelemetryEnabled;
    @UriParam(label="common", defaultValue="false")
    private boolean connectionSharingAcrossClientsEnabled;
    @UriParam(label="common", defaultValue="true")
    private boolean multipleWriteRegionsEnabled = true;
    @UriParam(label="common", defaultValue="true")
    private boolean readRequestsFallbackEnabled = true;
    @UriParam(label="common", defaultValue="true")
    private boolean contentResponseOnWriteEnabled = true;
    @UriParam(label="common", defaultValue="false")
    private boolean createDatabaseIfNotExists;
    @UriParam(label="common", defaultValue="false")
    private boolean createContainerIfNotExists;
    @UriParam(label="common")
    private ThroughputProperties throughputProperties;
    @UriParam(label="consumer", defaultValue="false")
    private boolean createLeaseDatabaseIfNotExists;
    @UriParam(label="consumer", defaultValue="false")
    private boolean createLeaseContainerIfNotExists;
    @UriParam(label="consumer", defaultValue="camel-lease")
    private String leaseContainerName = "camel-lease";
    @UriParam(label="consumer")
    private String leaseDatabaseName;
    @UriParam(label="consumer")
    private String hostName;
    @UriParam(label="consumer")
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    @UriParam(label="producer")
    private String query;
    @UriParam(label="producer")
    private String itemPartitionKey;
    @UriParam(label="producer")
    private String itemId;
    @UriParam(label="producer")
    private CosmosQueryRequestOptions queryRequestOptions;
    @UriParam(label="producer", defaultValue="listDatabases")
    private CosmosDbOperationsDefinition operation = CosmosDbOperationsDefinition.listDatabases;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public boolean isUseDefaultIdentity() {
        return this.useDefaultIdentity;
    }

    public void setUseDefaultIdentity(boolean useDefaultIdentity) {
        this.useDefaultIdentity = useDefaultIdentity;
    }

    public String getDatabaseEndpoint() {
        return this.databaseEndpoint;
    }

    public void setDatabaseEndpoint(String databaseEndpoint) {
        this.databaseEndpoint = databaseEndpoint;
    }

    public String getContainerPartitionKeyPath() {
        return this.containerPartitionKeyPath;
    }

    public void setContainerPartitionKeyPath(String containerPartitionKeyPath) {
        this.containerPartitionKeyPath = containerPartitionKeyPath;
    }

    public String getItemPartitionKey() {
        return this.itemPartitionKey;
    }

    public void setItemPartitionKey(String itemPartitionKey) {
        this.itemPartitionKey = itemPartitionKey;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public boolean isCreateDatabaseIfNotExists() {
        return this.createDatabaseIfNotExists;
    }

    public void setCreateDatabaseIfNotExists(boolean createDatabaseIfNotExists) {
        this.createDatabaseIfNotExists = createDatabaseIfNotExists;
    }

    public boolean isCreateContainerIfNotExists() {
        return this.createContainerIfNotExists;
    }

    public void setCreateContainerIfNotExists(boolean createContainerIfNotExists) {
        this.createContainerIfNotExists = createContainerIfNotExists;
    }

    public boolean isCreateLeaseDatabaseIfNotExists() {
        return this.createLeaseDatabaseIfNotExists;
    }

    public void setCreateLeaseDatabaseIfNotExists(boolean createLeaseDatabaseIfNotExists) {
        this.createLeaseDatabaseIfNotExists = createLeaseDatabaseIfNotExists;
    }

    public boolean isCreateLeaseContainerIfNotExists() {
        return this.createLeaseContainerIfNotExists;
    }

    public void setCreateLeaseContainerIfNotExists(boolean createLeaseContainerIfNotExists) {
        this.createLeaseContainerIfNotExists = createLeaseContainerIfNotExists;
    }

    public CosmosAsyncClient getCosmosAsyncClient() {
        return this.cosmosAsyncClient;
    }

    public void setCosmosAsyncClient(CosmosAsyncClient cosmosAsyncClient) {
        this.cosmosAsyncClient = cosmosAsyncClient;
    }

    public CosmosQueryRequestOptions getQueryRequestOptions() {
        return this.queryRequestOptions;
    }

    public void setQueryRequestOptions(CosmosQueryRequestOptions queryRequestOptions) {
        this.queryRequestOptions = queryRequestOptions;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getPreferredRegions() {
        return this.preferredRegions;
    }

    public void setPreferredRegions(String preferredRegions) {
        this.preferredRegions = preferredRegions;
    }

    public boolean isClientTelemetryEnabled() {
        return this.clientTelemetryEnabled;
    }

    public void setClientTelemetryEnabled(boolean clientTelemetryEnabled) {
        this.clientTelemetryEnabled = clientTelemetryEnabled;
    }

    public boolean isConnectionSharingAcrossClientsEnabled() {
        return this.connectionSharingAcrossClientsEnabled;
    }

    public void setConnectionSharingAcrossClientsEnabled(boolean connectionSharingAcrossClientsEnabled) {
        this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
    }

    public boolean isMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    public void setMultipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
    }

    public boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public void setReadRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ThroughputProperties getThroughputProperties() {
        return this.throughputProperties;
    }

    public void setThroughputProperties(ThroughputProperties throughputProperties) {
        this.throughputProperties = throughputProperties;
    }

    public boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public void setContentResponseOnWriteEnabled(boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
    }

    public String getLeaseContainerName() {
        return this.leaseContainerName;
    }

    public void setLeaseContainerName(String leaseContainerName) {
        this.leaseContainerName = leaseContainerName;
    }

    public String getLeaseDatabaseName() {
        return this.leaseDatabaseName;
    }

    public void setLeaseDatabaseName(String leaseDatabaseName) {
        this.leaseDatabaseName = leaseDatabaseName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public ChangeFeedProcessorOptions getChangeFeedProcessorOptions() {
        return this.changeFeedProcessorOptions;
    }

    public void setChangeFeedProcessorOptions(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
    }

    public CosmosDbOperationsDefinition getOperation() {
        return this.operation;
    }

    public void setOperation(CosmosDbOperationsDefinition operation) {
        this.operation = operation;
    }

    public CosmosDbConfiguration copy() {
        try {
            return (CosmosDbConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

