/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.client;

import com.azure.core.credential.TokenCredential;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import java.util.stream.Stream;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class CosmosDbClientFactory {
    private CosmosDbClientFactory() {
    }

    public static CosmosAsyncClient createCosmosAsyncClient(CosmosDbConfiguration configuration) {
        return CosmosDbClientFactory.createBasicClient(configuration).buildAsyncClient();
    }

    public static CosmosClient createCosmosSyncClient(CosmosDbConfiguration configuration) {
        return CosmosDbClientFactory.createBasicClient(configuration).buildClient();
    }

    private static CosmosClientBuilder createBasicClient(CosmosDbConfiguration configuration) {
        CosmosClientBuilder builder = new CosmosClientBuilder().endpoint(configuration.getDatabaseEndpoint()).contentResponseOnWriteEnabled(configuration.isContentResponseOnWriteEnabled()).consistencyLevel(configuration.getConsistencyLevel()).connectionSharingAcrossClientsEnabled(configuration.isConnectionSharingAcrossClientsEnabled()).clientTelemetryEnabled(configuration.isClientTelemetryEnabled()).multipleWriteRegionsEnabled(configuration.isMultipleWriteRegionsEnabled()).readRequestsFallbackEnabled(configuration.isReadRequestsFallbackEnabled());
        if (ObjectHelper.isNotEmpty((String)configuration.getPreferredRegions())) {
            builder.preferredRegions(Stream.of(configuration.getPreferredRegions().split(",")).map(String::trim).toList());
        }
        if (configuration.isUseDefaultIdentity()) {
            DefaultAzureCredentialBuilder defaultAzureCredentialBuilder = new DefaultAzureCredentialBuilder();
            builder.credential((TokenCredential)defaultAzureCredentialBuilder.build());
        } else {
            builder.key(configuration.getAccountKey());
        }
        return builder;
    }
}

