/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import com.azure.core.util.IterableStream;
import com.azure.cosmos.util.CosmosPagedFlux;
import org.apache.camel.util.ObjectHelper;
import reactor.core.publisher.Flux;

public final class CosmosDbUtils {
    private CosmosDbUtils() {
    }

    public static <T> Flux<T> convertCosmosPagedFluxToFluxResults(CosmosPagedFlux<T> pagedFlux, Integer maxResults) {
        Flux byPageFlux = ObjectHelper.isEmpty((Object)maxResults) ? pagedFlux.byPage() : pagedFlux.byPage(maxResults.intValue());
        return byPageFlux.flatMap(tFeedResponse -> {
            IterableStream elements = tFeedResponse.getElements();
            if (elements == null) {
                return Flux.empty();
            }
            return Flux.fromIterable((Iterable)elements);
        });
    }

    public static <T> Flux<T> convertCosmosPagedFluxToFluxResults(CosmosPagedFlux<T> pagedFlux) {
        return CosmosDbUtils.convertCosmosPagedFluxToFluxResults(pagedFlux, null);
    }

    public static void validateIfParameterIsNotEmpty(Object param, String paramName) {
        if (ObjectHelper.isEmpty((Object)param)) {
            throw new IllegalArgumentException(paramName + " cannot be empty!");
        }
    }
}

