/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.messaging.eventhubs.models.EventContext;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubsCheckpointUpdaterTimerTask
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubsCheckpointUpdaterTimerTask.class);
    private EventContext eventContext;
    private final AtomicInteger processedEvents;

    public EventHubsCheckpointUpdaterTimerTask(EventContext eventContext, AtomicInteger processedEvents) {
        this.eventContext = eventContext;
        this.processedEvents = processedEvents;
    }

    @Override
    public void run() {
        if (this.processedEvents.get() > 0) {
            LOG.debug("checkpointing offset after reaching timeout, with a batch of {}", (Object)this.processedEvents.get());
            this.eventContext.updateCheckpointAsync().subscribe(unused -> LOG.debug("Processed one event..."), error -> LOG.debug("Error when updating Checkpoint: {}", (Object)error.getMessage()), () -> {
                LOG.debug("Checkpoint updated.");
                this.processedEvents.set(0);
            });
        } else {
            LOG.debug("skip checkpointing offset even if timeout is reached. No events processed");
        }
    }

    public void setEventContext(EventContext eventContext) {
        this.eventContext = eventContext;
    }
}

