/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import java.net.URI;
import org.apache.camel.component.file.azure.CredentialType;
import org.apache.camel.component.file.azure.FilesPath;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class FilesConfiguration
extends RemoteFileConfiguration {
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String DEFAULT_INTERNET_DOMAIN = "file.core.windows.net";
    @UriParam(label="common", description="Shared key (storage account key)", secret=true)
    private String sharedKey;
    @UriPath(name="account", description="The account to use")
    @Metadata(required=true)
    private String account;
    @UriPath(name="share", description="The share to use")
    @Metadata(required=true)
    private String share;
    @UriParam(label="common", enums="SHARED_ACCOUNT_KEY,SHARED_KEY_CREDENTIAL,AZURE_IDENTITY,AZURE_SAS", defaultValue="SHARED_ACCOUNT_KEY", description="Determines the credential strategy to adopt")
    private CredentialType credentialType = CredentialType.SHARED_ACCOUNT_KEY;

    public FilesConfiguration() {
        this.setProtocol("azure-files");
    }

    public FilesConfiguration(URI uri) {
        super(uri);
        this.setSendNoop(false);
        this.setBinary(true);
        this.setPassiveMode(true);
    }

    protected void setDefaultPort() {
        this.setPort(443);
    }

    public void setDirectory(String path) {
        if (path == null || path.isBlank() || path.contains("//") || path.equals("/")) {
            throw new IllegalArgumentException("Illegal endpoint URI path (expected share[/dir]): " + path);
        }
        String dir = FilesPath.trimTrailingSeparator(path);
        int separator = (dir = FilesPath.trimLeadingSeparator(dir)).indexOf(47);
        if (separator == -1) {
            this.share = dir;
            dir = "/";
        } else {
            this.share = dir.substring(0, separator);
            dir = dir.substring(separator);
        }
        super.setDirectory(dir);
    }

    public String getShare() {
        return this.share;
    }

    public void setShare(String share) {
        this.share = share;
    }

    public String remoteServerInformation() {
        return this.getProtocol() + "://" + this.getAccount();
    }

    public void setHost(String host) {
        int dot = host.indexOf(46);
        boolean hasDot = dot >= 0;
        super.setHost((String)(hasDot ? host : this.account + ".file.core.windows.net"));
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }
}

