/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.key.vault.KeyVaultConfiguration;
import org.apache.camel.component.azure.key.vault.KeyVaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="azure-key-vault")
public class KeyVaultComponent
extends DefaultComponent {
    @Metadata
    private KeyVaultConfiguration configuration = new KeyVaultConfiguration();

    public KeyVaultComponent() {
    }

    public KeyVaultComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("A vault name must be specified.");
        }
        KeyVaultConfiguration epConfiguration = this.configuration != null ? this.configuration.copy() : new KeyVaultConfiguration();
        epConfiguration.setVaultName(remaining);
        KeyVaultEndpoint endpoint = new KeyVaultEndpoint(uri, (Component)this, epConfiguration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (epConfiguration.getSecretClient() == null && (epConfiguration.getClientId() == null || epConfiguration.getClientSecret() == null || epConfiguration.getTenantId() == null)) {
            throw new IllegalArgumentException("Azure Secret Client or client Id, client secret and tenant Id must be specified");
        }
        return endpoint;
    }
}

