/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.client;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusMessageBatch;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.CreateMessageBatchOptions;
import java.time.OffsetDateTime;
import org.apache.camel.util.ObjectHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceBusSenderAsyncClientWrapper {
    private final ServiceBusSenderAsyncClient client;

    public ServiceBusSenderAsyncClientWrapper(ServiceBusSenderAsyncClient client) {
        ObjectHelper.isNotEmpty((Object)client);
        this.client = client;
    }

    public String getFullyQualifiedNamespace() {
        return this.client.getFullyQualifiedNamespace();
    }

    public String getEntityPath() {
        return this.client.getEntityPath();
    }

    public Mono<Void> sendMessage(ServiceBusMessage message) {
        return this.client.sendMessage(message);
    }

    public Mono<Void> sendMessage(ServiceBusMessage message, ServiceBusTransactionContext transactionContext) {
        return this.client.sendMessage(message, transactionContext);
    }

    public Mono<Void> sendMessages(Iterable<ServiceBusMessage> messages, ServiceBusTransactionContext transactionContext) {
        return this.client.sendMessages(messages, transactionContext);
    }

    public Mono<Void> sendMessages(Iterable<ServiceBusMessage> messages) {
        return this.client.sendMessages(messages);
    }

    public Mono<Void> sendMessages(ServiceBusMessageBatch batch) {
        return this.client.sendMessages(batch);
    }

    public Mono<Void> sendMessages(ServiceBusMessageBatch batch, ServiceBusTransactionContext transactionContext) {
        return this.client.sendMessages(batch, transactionContext);
    }

    public Mono<ServiceBusMessageBatch> createMessageBatch() {
        return this.client.createMessageBatch();
    }

    public Mono<ServiceBusMessageBatch> createMessageBatch(CreateMessageBatchOptions options) {
        return this.client.createMessageBatch(options);
    }

    public Mono<Long> scheduleMessage(ServiceBusMessage message, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext transactionContext) {
        return this.client.scheduleMessage(message, scheduledEnqueueTime, transactionContext);
    }

    public Mono<Long> scheduleMessage(ServiceBusMessage message, OffsetDateTime scheduledEnqueueTime) {
        return this.client.scheduleMessage(message, scheduledEnqueueTime);
    }

    public Flux<Long> scheduleMessages(Iterable<ServiceBusMessage> messages, OffsetDateTime scheduledEnqueueTime) {
        return this.client.scheduleMessages(messages, scheduledEnqueueTime);
    }

    public Flux<Long> scheduleMessages(Iterable<ServiceBusMessage> messages, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext transactionContext) {
        return this.client.scheduleMessages(messages, scheduledEnqueueTime, transactionContext);
    }

    public Mono<Void> cancelScheduledMessage(long sequenceNumber) {
        return this.client.cancelScheduledMessage(sequenceNumber);
    }

    public Mono<Void> cancelScheduledMessages(Iterable<Long> sequenceNumbers) {
        return this.client.cancelScheduledMessages(sequenceNumbers);
    }

    public Mono<ServiceBusTransactionContext> createTransaction() {
        return this.client.createTransaction();
    }

    public Mono<Void> commitTransaction(ServiceBusTransactionContext transactionContext) {
        return this.client.commitTransaction(transactionContext);
    }

    public Mono<Void> rollbackTransaction(ServiceBusTransactionContext transactionContext) {
        return this.client.rollbackTransaction(transactionContext);
    }

    public void close() {
        this.client.close();
    }
}

