/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ServiceBusEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topicOrQueueName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "azure-servicebus".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "topicOrQueueName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(29);
        props.add("amqpRetryOptions");
        props.add("amqpTransportType");
        props.add("binary");
        props.add("bridgeErrorHandler");
        props.add("clientOptions");
        props.add("connectionString");
        props.add("consumerOperation");
        props.add("credentialType");
        props.add("disableAutoComplete");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fullyQualifiedNamespace");
        props.add("lazyStartProducer");
        props.add("maxAutoLockRenewDuration");
        props.add("peekNumMaxMessages");
        props.add("prefetchCount");
        props.add("producerOperation");
        props.add("proxyOptions");
        props.add("receiverAsyncClient");
        props.add("reconnectDelay");
        props.add("scheduledEnqueueTime");
        props.add("senderAsyncClient");
        props.add("serviceBusReceiveMode");
        props.add("serviceBusTransactionContext");
        props.add("serviceBusType");
        props.add("subQueue");
        props.add("subscriptionName");
        props.add("tokenCredential");
        props.add("topicOrQueueName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("connectionString");
        secretProps.add("tokenCredential");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

