/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.client;

import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.AbandonOptions;
import com.azure.messaging.servicebus.models.CompleteOptions;
import com.azure.messaging.servicebus.models.DeadLetterOptions;
import com.azure.messaging.servicebus.models.DeferOptions;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.util.ObjectHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceBusReceiverAsyncClientWrapper {
    private ServiceBusReceiverAsyncClient client;

    public ServiceBusReceiverAsyncClientWrapper(ServiceBusReceiverAsyncClient client) {
        ObjectHelper.isNotEmpty((Object)client);
        this.client = client;
    }

    public String getFullyQualifiedNamespace() {
        return this.client.getFullyQualifiedNamespace();
    }

    public String getEntityPath() {
        return this.client.getEntityPath();
    }

    public Mono<Void> abandon(ServiceBusReceivedMessage message) {
        return this.client.abandon(message);
    }

    public Mono<Void> abandon(ServiceBusReceivedMessage message, AbandonOptions options) {
        return this.client.abandon(message, options);
    }

    public Mono<Void> complete(ServiceBusReceivedMessage message) {
        return this.client.complete(message);
    }

    public Mono<Void> complete(ServiceBusReceivedMessage message, CompleteOptions options) {
        return this.client.complete(message, options);
    }

    public Mono<Void> defer(ServiceBusReceivedMessage message) {
        return this.client.defer(message);
    }

    public Mono<Void> defer(ServiceBusReceivedMessage message, DeferOptions options) {
        return this.client.defer(message, options);
    }

    public Mono<Void> deadLetter(ServiceBusReceivedMessage message) {
        return this.client.deadLetter(message);
    }

    public Mono<Void> deadLetter(ServiceBusReceivedMessage message, DeadLetterOptions options) {
        return this.client.deadLetter(message, options);
    }

    public Mono<byte[]> getSessionState() {
        return this.client.getSessionState();
    }

    public Mono<ServiceBusReceivedMessage> peekMessage() {
        return this.client.peekMessage();
    }

    public Mono<ServiceBusReceivedMessage> peekMessage(long sequenceNumber) {
        return this.client.peekMessage(sequenceNumber);
    }

    public Flux<ServiceBusReceivedMessage> peekMessages(int maxMessages) {
        return this.client.peekMessages(maxMessages);
    }

    public Flux<ServiceBusReceivedMessage> peekMessages(int maxMessages, long sequenceNumber) {
        return this.client.peekMessages(maxMessages, sequenceNumber);
    }

    public Flux<ServiceBusReceivedMessage> receiveMessages() {
        return this.client.receiveMessages();
    }

    public Mono<ServiceBusReceivedMessage> receiveDeferredMessage(long sequenceNumber) {
        return this.client.receiveDeferredMessage(sequenceNumber);
    }

    public Flux<ServiceBusReceivedMessage> receiveDeferredMessages(Iterable<Long> sequenceNumbers) {
        return this.client.receiveDeferredMessages(sequenceNumbers);
    }

    public Mono<OffsetDateTime> renewMessageLock(ServiceBusReceivedMessage message) {
        return this.client.renewMessageLock(message);
    }

    public Mono<Void> renewMessageLock(ServiceBusReceivedMessage message, Duration maxLockRenewalDuration) {
        return this.client.renewMessageLock(message, maxLockRenewalDuration);
    }

    public Mono<OffsetDateTime> renewSessionLock() {
        return this.client.renewSessionLock();
    }

    public Mono<Void> renewSessionLock(Duration maxLockRenewalDuration) {
        return this.client.renewSessionLock(maxLockRenewalDuration);
    }

    public Mono<Void> setSessionState(byte[] sessionState) {
        return this.client.setSessionState(sessionState);
    }

    public Mono<ServiceBusTransactionContext> createTransaction() {
        return this.client.createTransaction();
    }

    public Mono<Void> commitTransaction(ServiceBusTransactionContext transactionContext) {
        return this.client.commitTransaction(transactionContext);
    }

    public Mono<Void> rollbackTransaction(ServiceBusTransactionContext transactionContext) {
        return this.client.rollbackTransaction(transactionContext);
    }

    public void close() {
        this.client.close();
    }
}

