/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.operations;

import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import org.apache.camel.component.azure.servicebus.client.ServiceBusReceiverAsyncClientWrapper;
import org.apache.camel.util.ObjectHelper;
import reactor.core.publisher.Flux;

public class ServiceBusReceiverOperations {
    private final ServiceBusReceiverAsyncClientWrapper client;

    public ServiceBusReceiverOperations(ServiceBusReceiverAsyncClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client");
        this.client = client;
    }

    public Flux<ServiceBusReceivedMessage> receiveMessages() {
        return this.client.receiveMessages();
    }

    public Flux<ServiceBusReceivedMessage> peekMessages(Integer numMaxMessages) {
        if (ObjectHelper.isEmpty((Object)numMaxMessages)) {
            return this.client.peekMessage().flux();
        }
        return this.client.peekMessages(numMaxMessages);
    }
}

