/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.storage.blob.BlobConstants;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class BlobConfiguration
implements Cloneable {
    @UriPath
    private String accountName;
    @UriPath
    private String containerName;
    @UriParam
    private StorageSharedKeyCredential credentials;
    @UriParam
    @Metadata(autowired=true)
    private BlobServiceClient serviceClient;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="producer", enums="listBlobContainers,createBlobContainer,deleteBlobContainer,listBlobs,getBlob,deleteBlob,downloadBlobToFile,downloadLink,uploadBlockBlob,stageBlockBlobList,commitBlobBlockList,getBlobBlockList,createAppendBlob,commitAppendBlob,createPageBlob,uploadPageBlob,resizePageBlob,clearPageBlob,getPageBlobRanges", defaultValue="listBlobContainers")
    private BlobOperationsDefinition operation = BlobOperationsDefinition.listBlobContainers;
    @UriParam(label="common")
    private String blobName;
    @UriParam(label="common", enums="blockblob,appendblob,pageblob", defaultValue="blockblob")
    private BlobType blobType = BlobType.blockblob;
    @UriParam(label="common")
    private String fileDir;
    @UriParam(label="common", defaultValue="0")
    private long blobOffset;
    @UriParam(label="common")
    private Long dataCount;
    @UriParam(label="common")
    private Duration timeout;
    @UriParam(label="common")
    private String prefix;
    @UriParam(label="common")
    private Integer maxResultsPerPage;
    @UriParam(label="common", defaultValue="0")
    private int maxRetryRequests;
    @UriParam(defaultValue="true")
    private boolean closeStreamAfterRead = true;
    @UriParam(label="producer", defaultValue="true")
    private boolean closeStreamAfterWrite = true;
    @UriParam(label="producer")
    private Long downloadLinkExpiration;
    @UriParam(label="producer", defaultValue="true")
    private boolean commitBlockListLater = true;
    @UriParam(label="producer", defaultValue="true")
    private boolean createAppendBlob = true;
    @UriParam(label="producer", defaultValue="true")
    private boolean createPageBlob = true;
    @UriParam(label="producer", defaultValue="0")
    private Long blobSequenceNumber;
    @UriParam(label="producer", defaultValue="512")
    private Long pageBlobSize = BlobConstants.PAGE_BLOB_DEFAULT_SIZE;
    @UriParam(label="producer", defaultValue="COMMITTED")
    private BlockListType blockListType = BlockListType.COMMITTED;
    @UriParam(label="common")
    private String regex;

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public StorageSharedKeyCredential getCredentials() {
        return this.credentials;
    }

    public void setCredentials(StorageSharedKeyCredential credentials) {
        this.credentials = credentials;
    }

    public BlobServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public void setServiceClient(BlobServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public BlobOperationsDefinition getOperation() {
        return this.operation;
    }

    public void setOperation(BlobOperationsDefinition operation) {
        this.operation = operation;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public void setBlobName(String blobName) {
        this.blobName = blobName;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public void setBlobType(BlobType blobType) {
        this.blobType = blobType;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public long getBlobOffset() {
        return this.blobOffset;
    }

    public void setBlobOffset(long blobOffset) {
        this.blobOffset = blobOffset;
    }

    public Long getDataCount() {
        return this.dataCount;
    }

    public void setDataCount(Long dataCount) {
        this.dataCount = dataCount;
    }

    public int getMaxRetryRequests() {
        return this.maxRetryRequests;
    }

    public void setMaxRetryRequests(int maxRetryRequests) {
        this.maxRetryRequests = maxRetryRequests;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Integer getMaxResultsPerPage() {
        return this.maxResultsPerPage;
    }

    public void setMaxResultsPerPage(Integer maxResultsPerPage) {
        this.maxResultsPerPage = maxResultsPerPage;
    }

    public boolean isCloseStreamAfterRead() {
        return this.closeStreamAfterRead;
    }

    public void setCloseStreamAfterRead(boolean closeStreamAfterRead) {
        this.closeStreamAfterRead = closeStreamAfterRead;
    }

    public boolean isCloseStreamAfterWrite() {
        return this.closeStreamAfterWrite;
    }

    public void setCloseStreamAfterWrite(boolean closeStreamAfterWrite) {
        this.closeStreamAfterWrite = closeStreamAfterWrite;
    }

    public Long getPageBlobSize() {
        return this.pageBlobSize;
    }

    public void setPageBlobSize(Long pageBlobSize) {
        this.pageBlobSize = pageBlobSize;
    }

    public Long getDownloadLinkExpiration() {
        return this.downloadLinkExpiration;
    }

    public void setDownloadLinkExpiration(Long downloadLinkExpiration) {
        this.downloadLinkExpiration = downloadLinkExpiration;
    }

    public boolean isCommitBlockListLater() {
        return this.commitBlockListLater;
    }

    public void setCommitBlockListLater(boolean commitBlockListLater) {
        this.commitBlockListLater = commitBlockListLater;
    }

    public boolean isCreateAppendBlob() {
        return this.createAppendBlob;
    }

    public void setCreateAppendBlob(boolean createAppendBlob) {
        this.createAppendBlob = createAppendBlob;
    }

    public boolean isCreatePageBlob() {
        return this.createPageBlob;
    }

    public void setCreatePageBlob(boolean createPageBlob) {
        this.createPageBlob = createPageBlob;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public void setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
    }

    public BlockListType getBlockListType() {
        return this.blockListType;
    }

    public void setBlockListType(BlockListType blockListType) {
        this.blockListType = blockListType;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public BlobConfiguration copy() {
        try {
            return (BlobConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

