/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.client;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Locale;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class BlobClientFactory {
    private static final String SERVICE_URI_SEGMENT = ".blob.core.windows.net";

    private BlobClientFactory() {
    }

    public static BlobServiceClient createBlobServiceClient(BlobConfiguration configuration) {
        return new BlobServiceClientBuilder().endpoint(BlobClientFactory.buildAzureEndpointUri(configuration)).credential(BlobClientFactory.getCredentialForClient(configuration)).buildClient();
    }

    private static String buildAzureEndpointUri(BlobConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.blob.core.windows.net", BlobClientFactory.getAccountName(configuration));
    }

    private static StorageSharedKeyCredential getCredentialForClient(BlobConfiguration configuration) {
        StorageSharedKeyCredential storageSharedKeyCredential = configuration.getCredentials();
        if (storageSharedKeyCredential != null) {
            return storageSharedKeyCredential;
        }
        return new StorageSharedKeyCredential(configuration.getAccountName(), configuration.getAccessKey());
    }

    private static String getAccountName(BlobConfiguration configuration) {
        return !ObjectHelper.isEmpty((Object)configuration.getCredentials()) ? configuration.getCredentials().getAccountName() : configuration.getAccountName();
    }
}

