/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobConsumer;
import org.apache.camel.component.azure.storage.blob.BlobProducer;
import org.apache.camel.component.azure.storage.blob.client.BlobClientFactory;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.3.0", scheme="azure-storage-blob", title="Azure Storage Blob Service", syntax="azure-storage-blob:accountName/containerName", category={Category.CLOUD, Category.FILE})
public class BlobEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private BlobServiceClient blobServiceClient;
    @UriParam
    private BlobConfiguration configuration;

    public BlobEndpoint(String uri, Component component, BlobConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() {
        return new BlobProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getContainerName())) {
            throw new IllegalArgumentException("Container name must be set.");
        }
        BlobConsumer consumer = new BlobConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.blobServiceClient = this.configuration.getServiceClient() != null ? this.configuration.getServiceClient() : BlobClientFactory.createBlobServiceClient(this.configuration);
    }

    public void setResponseOnExchange(BlobOperationResponse response, Exchange exchange) {
        Message message = exchange.getIn();
        message.setBody(response.getBody());
        message.setHeaders(response.getHeaders());
    }

    public BlobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobConfiguration configuration) {
        this.configuration = configuration;
    }

    public BlobServiceClient getBlobServiceClient() {
        return this.blobServiceClient;
    }

    public void setBlobServiceClient(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = blobServiceClient;
    }
}

