/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.core.http.rest.Response;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.PageBlobItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;

public final class BlobOperationResponse {
    private Object body;
    private Map<String, Object> headers = new HashMap<String, Object>();

    private BlobOperationResponse(Object body, Map<String, Object> headers) {
        this.body = body;
        this.headers = headers;
    }

    private BlobOperationResponse(Object body) {
        this.setBody(body);
    }

    public static BlobOperationResponse create(Object body) {
        return new BlobOperationResponse(body);
    }

    public static BlobOperationResponse create(Object body, Map<String, Object> headers) {
        return new BlobOperationResponse(body, headers);
    }

    public static BlobOperationResponse createWithEmptyBody(Map<String, Object> headers) {
        return new BlobOperationResponse(true, headers);
    }

    public static BlobOperationResponse createWithEmptyBody() {
        return new BlobOperationResponse(true);
    }

    public static BlobOperationResponse create(Response response) {
        return BlobOperationResponse.buildResponse(response, false);
    }

    public static BlobOperationResponse createWithEmptyBody(Response response) {
        return BlobOperationResponse.buildResponse(response, true);
    }

    private static BlobOperationResponse buildResponse(Response response, boolean emptyBody) {
        Object body;
        Object object = body = emptyBody ? Boolean.valueOf(true) : response.getValue();
        BlobExchangeHeaders exchangeHeaders = response.getValue() instanceof BlockBlobItem ? BlobExchangeHeaders.createBlobExchangeHeadersFromBlockBlobItem((BlockBlobItem)response.getValue()) : (response.getValue() instanceof AppendBlobItem ? BlobExchangeHeaders.createBlobExchangeHeadersFromAppendBlobItem((AppendBlobItem)response.getValue()) : (response.getValue() instanceof PageBlobItem ? BlobExchangeHeaders.createBlobExchangeHeadersFromPageBlobItem((PageBlobItem)response.getValue()) : (response.getValue() instanceof BlobProperties ? BlobExchangeHeaders.createBlobExchangeHeadersFromBlobProperties((BlobProperties)response.getValue()) : BlobExchangeHeaders.create())));
        exchangeHeaders.httpHeaders(response.getHeaders());
        return new BlobOperationResponse(body, exchangeHeaders.toMap());
    }

    public Object getBody() {
        return this.body;
    }

    private void setBody(Object body) {
        this.body = body;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    private void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }
}

