/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.component.azure.storage.blob.CredentialType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="azure-storage-blob")
public class BlobComponent
extends HealthCheckComponent {
    @Metadata
    private BlobConfiguration configuration = new BlobConfiguration();

    public BlobComponent() {
    }

    public BlobComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("At least the account name must be specified.");
        }
        BlobConfiguration config = this.configuration != null ? this.configuration.copy() : new BlobConfiguration();
        String[] parts = remaining.split("/");
        config.setAccountName(parts[0]);
        if (parts.length > 1) {
            config.setContainerName(parts[1]);
        }
        BlobEndpoint endpoint = new BlobEndpoint(uri, (Component)this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        this.initCredentialConfig(config);
        this.validateConfigurations(config);
        return endpoint;
    }

    public BlobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobConfiguration configuration) {
        this.configuration = configuration;
    }

    private void initCredentialConfig(BlobConfiguration configuration) {
        BlobServiceClient client = configuration.getServiceClient();
        if (client == null) {
            if (configuration.getCredentialType() == null) {
                configuration.setCredentialType(CredentialType.AZURE_IDENTITY);
            } else if (CredentialType.SHARED_KEY_CREDENTIAL.equals((Object)configuration.getCredentialType())) {
                Set storageSharedKeyCredentials = this.getCamelContext().getRegistry().findByType(StorageSharedKeyCredential.class);
                storageSharedKeyCredentials.stream().findFirst().ifPresent(configuration::setCredentials);
            } else if (CredentialType.AZURE_SAS.equals((Object)configuration.getCredentialType())) {
                configuration.setCredentialType(CredentialType.AZURE_SAS);
            }
        }
    }

    private void validateConfigurations(BlobConfiguration configuration) {
        if (configuration.getServiceClient() == null) {
            if (CredentialType.SHARED_KEY_CREDENTIAL.equals((Object)configuration.getCredentialType()) && configuration.getCredentials() == null) {
                throw new IllegalArgumentException("When using shared key credential, credentials must be provided.");
            }
            if (CredentialType.SHARED_ACCOUNT_KEY.equals((Object)configuration.getCredentialType()) && configuration.getAccessKey() == null) {
                throw new IllegalArgumentException("When using shared account key, access key must be provided.");
            }
            if (CredentialType.AZURE_SAS.equals((Object)configuration.getCredentialType()) && configuration.getSasToken() == null) {
                throw new IllegalArgumentException("When using Azure SAS, SAS Token must be provided.");
            }
        }
    }
}

