/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.client;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.util.ObjectHelper;

public class QueueClientWrapper {
    private QueueClient client;

    public QueueClientWrapper(QueueClient client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
    }

    public Response<Void> create(Map<String, String> metadata, Duration timeout) {
        return this.client.createWithResponse(metadata, timeout, Context.NONE);
    }

    public Response<Void> delete(Duration timeout) {
        return this.client.deleteWithResponse(timeout, Context.NONE);
    }

    public Response<Void> clearMessages(Duration timeout) {
        return this.client.clearMessagesWithResponse(timeout, Context.NONE);
    }

    public Response<SendMessageResult> sendMessage(String messageText, Duration visibilityTimeout, Duration timeToLive, Duration timeout) {
        return this.client.sendMessageWithResponse(messageText, visibilityTimeout, timeToLive, timeout, Context.NONE);
    }

    public Response<Void> deleteMessage(String messageId, String popReceipt, Duration timeout) {
        return this.client.deleteMessageWithResponse(messageId, popReceipt, timeout, Context.NONE);
    }

    public List<QueueMessageItem> receiveMessages(Integer maxMessages, Duration visibilityTimeout, Duration timeout) {
        return this.client.receiveMessages(maxMessages, visibilityTimeout, timeout, Context.NONE).stream().collect(Collectors.toList());
    }

    public List<PeekedMessageItem> peekMessages(Integer maxMessages, Duration timeout) {
        return this.client.peekMessages(maxMessages, timeout, Context.NONE).stream().collect(Collectors.toList());
    }

    public Response<UpdateMessageResult> updateMessage(String messageId, String popReceipt, String messageText, Duration visibilityTimeout, Duration timeout) {
        return this.client.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, timeout, Context.NONE);
    }
}

