/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.core.util.BinaryData;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueStorageException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueEndpoint;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.client.QueueClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperations;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(QueueConsumer.class);
    private QueueClientWrapper clientWrapper;
    private QueueOperations queueOperations;

    public QueueConsumer(QueueEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.clientWrapper = new QueueClientWrapper(this.getServiceClient().getQueueClient(this.getConfiguration().getQueueName()));
        this.queueOperations = new QueueOperations(this.getConfiguration(), this.clientWrapper);
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        try {
            List<QueueMessageItem> messageItems = this.clientWrapper.receiveMessages(this.getConfiguration().getMaxMessages(), this.getConfiguration().getVisibilityTimeout(), this.getConfiguration().getTimeout());
            LOG.trace("Receiving messages [{}]...", messageItems);
            Queue<Exchange> exchanges = this.createExchanges(messageItems);
            return this.processBatch(CastUtils.cast(exchanges));
        }
        catch (QueueStorageException ex) {
            if (404 == ex.getStatusCode()) {
                return 0;
            }
            throw ex;
        }
    }

    private Queue<Exchange> createExchanges(List<QueueMessageItem> messageItems) {
        return messageItems.stream().map(this::createExchange).collect(Collectors.toCollection(LinkedList::new));
    }

    private QueueServiceClient getServiceClient() {
        return this.getEndpoint().getQueueServiceClient();
    }

    private QueueConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public QueueEndpoint getEndpoint() {
        return (QueueEndpoint)super.getEndpoint();
    }

    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            final String messageId = (String)exchange.getIn().getHeader("CamelAzureStorageQueueMessageId", String.class);
            final String popReceipt = (String)exchange.getIn().getHeader("CamelAzureStorageQueuePopReceipt", String.class);
            final Duration timeout = (Duration)exchange.getIn().getHeader("CamelAzureStorageQueueTimeout", Duration.class);
            exchange.getExchangeExtension().addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    exchange.getIn().setHeader("CamelAzureStorageQueueMessageId", (Object)messageId);
                    exchange.getIn().setHeader("CamelAzureStorageQueuePopReceipt", (Object)popReceipt);
                    exchange.getIn().setHeader("CamelAzureStorageQueueTimeout", (Object)timeout);
                    QueueConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    QueueConsumer.this.processRollback(exchange);
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
        }
        return total;
    }

    private Exchange createExchange(QueueMessageItem messageItem) {
        Exchange exchange = this.createExchange(true);
        Message message = exchange.getIn();
        BinaryData data = messageItem.getBody();
        message.setBody((Object)(data == null ? null : data.toString()));
        message.setHeaders(QueueExchangeHeaders.createQueueExchangeHeadersFromQueueMessageItem(messageItem).toMap());
        return exchange;
    }

    private void processCommit(Exchange exchange) {
        try {
            LOG.trace("Deleting message with pop receipt handle {}...", (Object)QueueExchangeHeaders.getPopReceiptFromHeaders(exchange));
            this.queueOperations.deleteMessage(exchange);
        }
        catch (QueueStorageException ex) {
            this.getExceptionHandler().handleException("Error occurred during deleting message. This exception is ignored.", exchange, (Throwable)ex);
        }
    }

    private void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange. Will attempt to process the message on next poll.", exchange, (Throwable)cause);
        }
    }
}

