/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.client;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import java.util.Locale;
import org.apache.camel.component.azure.storage.queue.CredentialType;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class QueueClientFactory {
    private static final String SERVICE_URI_SEGMENT = ".queue.core.windows.net";

    private QueueClientFactory() {
    }

    public static QueueServiceClient createQueueServiceClient(QueueConfiguration configuration) {
        if (configuration.getCredentialType().equals((Object)CredentialType.SHARED_KEY_CREDENTIAL) || configuration.getCredentialType().equals((Object)CredentialType.SHARED_ACCOUNT_KEY)) {
            return new QueueServiceClientBuilder().endpoint(QueueClientFactory.buildAzureEndpointUri(configuration)).credential(QueueClientFactory.getCredentialForClient(configuration)).buildClient();
        }
        return new QueueServiceClientBuilder().endpoint(QueueClientFactory.buildAzureEndpointUri(configuration)).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildClient();
    }

    private static String buildAzureEndpointUri(QueueConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.queue.core.windows.net", QueueClientFactory.getAccountName(configuration));
    }

    private static StorageSharedKeyCredential getCredentialForClient(QueueConfiguration configuration) {
        StorageSharedKeyCredential storageSharedKeyCredential = configuration.getCredentials();
        if (storageSharedKeyCredential != null) {
            return storageSharedKeyCredential;
        }
        return new StorageSharedKeyCredential(configuration.getAccountName(), configuration.getAccessKey());
    }

    private static String getAccountName(QueueConfiguration configuration) {
        return !ObjectHelper.isEmpty((Object)configuration.getCredentials()) ? configuration.getCredentials().getAccountName() : configuration.getAccountName();
    }
}

