/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import org.apache.camel.spi.Metadata;

public final class QueueConstants {
    private static final String HEADER_PREFIX = "CamelAzureStorageQueue";
    @Metadata(description="Returns non-parsed httpHeaders that can be used by the user.", javaType="HttpHeaders")
    public static final String RAW_HTTP_HEADERS = "CamelAzureStorageQueueRawHttpHeaders";
    @Metadata(label="producer", description="(createQueue) Metadata to associate with the queue", javaType="Map<String,String>")
    public static final String METADATA = "CamelAzureStorageQueueMetadata";
    @Metadata(description="The ID of the message.", javaType="String")
    public static final String MESSAGE_ID = "CamelAzureStorageQueueMessageId";
    @Metadata(description="The time the Message was inserted into the Queue.", javaType="OffsetDateTime")
    public static final String INSERTION_TIME = "CamelAzureStorageQueueInsertionTime";
    @Metadata(description="The time that the Message will expire and be automatically deleted.", javaType="OffsetDateTime")
    public static final String EXPIRATION_TIME = "CamelAzureStorageQueueExpirationTime";
    @Metadata(label="producer", description="(deleteMessage, updateMessage) Unique identifier that must match for the message to be deleted or updated. If deletion fails using this pop receipt then the message has been dequeued by another client.", javaType="String")
    public static final String POP_RECEIPT = "CamelAzureStorageQueuePopReceipt";
    @Metadata(description="The time that the message will again become visible in the Queue.", javaType="OffsetDateTime")
    public static final String TIME_NEXT_VISIBLE = "CamelAzureStorageQueueTimeNextVisible";
    @Metadata(description="The number of times the message has been dequeued.", javaType="long")
    public static final String DEQUEUE_COUNT = "CamelAzureStorageQueueDequeueCount";
    @Metadata(label="producer", description="(All) Specify the producer operation to execute, please see the doc on this page related to producer operation.", javaType="org.apache.camel.component.azure.storage.queue.QueueOperationDefinition")
    public static final String QUEUE_OPERATION = "CamelAzureStorageQueueOperation";
    @Metadata(label="producer", description="(All) Override the queue name.", javaType="String")
    public static final String QUEUE_NAME = "CamelAzureStorageQueueName";
    @Metadata(label="producer", description="(listQueues) Options for listing queues", javaType="QueuesSegmentOptions")
    public static final String QUEUES_SEGMENT_OPTIONS = "CamelAzureStorageQueueSegmentOptions";
    @Metadata(label="producer", description="(All) An optional timeout value beyond which a `RuntimeException` will be raised.", javaType="Duration")
    public static final String TIMEOUT = "CamelAzureStorageQueueTimeout";
    @Metadata(label="producer", description="(receiveMessages, peekMessages) Maximum number of messages to get, if there are less messages exist in the queue than requested all the messages will be returned. If left empty only 1 message will be retrieved, the allowed range is 1 to 32 messages.", javaType="Integer")
    public static final String MAX_MESSAGES = "CamelAzureStorageQueueMaxMessages";
    @Metadata(label="producer", description="(sendMessage, receiveMessages, updateMessage) The timeout period for how long the message is invisible in the queue. If unset the value will default to 0 and the message will be instantly visible. The timeout must be between 0 seconds and 7 days.", javaType="Duration")
    public static final String VISIBILITY_TIMEOUT = "CamelAzureStorageQueueVisibilityTimeout";
    @Metadata(label="producer", description="(sendMessage) How long the message will stay alive in the queue. If unset the value will default to 7 days, if -1 is passed the message will not expire. The time to live must be -1 or any positive number.", javaType="Duration")
    public static final String TIME_TO_LIVE = "CamelAzureStorageQueueTimeToLive";
    @Metadata(label="producer", description="(sendMessage) When is set to `true`, the queue will be automatically created when sending messages to the queue.", javaType="boolean")
    public static final String CREATE_QUEUE = "CamelAzureStorageQueueCreateQueue";

    private QueueConstants() {
    }
}

