/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.annotations.EagerClassloaded;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ReactiveExecutor")
@EagerClassloaded
public class DefaultReactiveExecutor
extends ServiceSupport
implements ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReactiveExecutor.class);
    private final ThreadLocal<Worker> workers = ThreadLocal.withInitial(new Supplier<Worker>(){

        @Override
        public Worker get() {
            int number = DefaultReactiveExecutor.this.createdWorkers.incrementAndGet();
            return new Worker(number, DefaultReactiveExecutor.this);
        }
    });
    private boolean statisticsEnabled;
    private final AtomicInteger createdWorkers = new AtomicInteger();
    private final LongAdder runningWorkers = new LongAdder();
    private final LongAdder pendingTasks = new LongAdder();

    public void schedule(Runnable runnable) {
        this.workers.get().schedule(runnable, false, false, false);
    }

    public void scheduleMain(Runnable runnable) {
        this.workers.get().schedule(runnable, true, true, false);
    }

    public void scheduleSync(Runnable runnable) {
        this.workers.get().schedule(runnable, false, true, true);
    }

    public void scheduleQueue(Runnable runnable) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("ScheduleQueue: {}", (Object)runnable);
        }
        this.workers.get().queue.add(runnable);
    }

    public boolean executeFromQueue() {
        return this.workers.get().executeFromQueue();
    }

    @ManagedAttribute(description="Whether statistics is enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Number of created workers")
    public int getCreatedWorkers() {
        return this.createdWorkers.get();
    }

    @ManagedAttribute(description="Number of running workers")
    public int getRunningWorkers() {
        return this.runningWorkers.intValue();
    }

    @ManagedAttribute(description="Number of pending tasks")
    public int getPendingTasks() {
        return this.pendingTasks.intValue();
    }

    public static void onClassloaded(Logger log) {
        log.trace("Loaded DefaultReactiveExecutor");
        Worker dummy = new Worker(-1, null);
        log.trace("Loaded {}", (Object)dummy.getClass().getName());
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled() && this.statisticsEnabled) {
            LOG.debug("Stopping DefaultReactiveExecutor [createdWorkers: {}, runningWorkers: {}, pendingTasks: {}]", new Object[]{this.getCreatedWorkers(), this.getRunningWorkers(), this.getPendingTasks()});
        }
    }

    protected void doShutdown() throws Exception {
        this.workers.remove();
    }

    private static class Worker {
        private final int number;
        private final DefaultReactiveExecutor executor;
        private final boolean stats;
        private volatile Deque<Runnable> queue = new ArrayDeque<Runnable>();
        private volatile Deque<Deque<Runnable>> back;
        private volatile boolean running;

        public Worker(int number, DefaultReactiveExecutor executor) {
            this.number = number;
            this.executor = executor;
            this.stats = executor != null && executor.isStatisticsEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(Runnable runnable, boolean first, boolean main, boolean sync) {
            block22: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Schedule [first={}, main={}, sync={}]: {}", new Object[]{first, main, sync, runnable});
                }
                if (main && !this.queue.isEmpty()) {
                    if (this.back == null) {
                        this.back = new ArrayDeque<Deque<Runnable>>();
                    }
                    this.back.push(this.queue);
                    this.queue = new ArrayDeque<Runnable>();
                }
                if (first) {
                    this.queue.addFirst(runnable);
                    if (this.stats) {
                        this.executor.pendingTasks.increment();
                    }
                } else {
                    this.queue.addLast(runnable);
                    if (this.stats) {
                        this.executor.pendingTasks.increment();
                    }
                }
                if (!this.running || sync) {
                    this.running = true;
                    if (this.stats) {
                        this.executor.runningWorkers.increment();
                    }
                    block5: while (true) {
                        while (true) {
                            Runnable polled;
                            if ((polled = this.queue.pollFirst()) == null) {
                                if (this.back != null && !this.back.isEmpty()) {
                                    this.queue = this.back.pollFirst();
                                    continue;
                                }
                                break block22;
                            }
                            try {
                                if (this.stats) {
                                    this.executor.pendingTasks.decrement();
                                }
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Worker #{} running: {}", (Object)this.number, (Object)polled);
                                }
                                polled.run();
                                continue block5;
                            }
                            catch (Throwable t) {
                                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t.getMessage(), (Object)t);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        this.running = false;
                        if (this.stats) {
                            this.executor.runningWorkers.decrement();
                        }
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Queuing reactive work: {}", (Object)runnable);
                }
            }
        }

        boolean executeFromQueue() {
            Runnable polled;
            Runnable runnable = polled = this.queue != null ? this.queue.pollFirst() : null;
            if (polled == null) {
                return false;
            }
            try {
                if (this.stats) {
                    this.executor.pendingTasks.decrement();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running: {}", (Object)polled);
                }
                polled.run();
            }
            catch (Throwable t) {
                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t.getMessage(), (Object)t);
            }
            return true;
        }
    }
}

