/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.DefaultUnitOfWork;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.PatternHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCUnitOfWork
extends DefaultUnitOfWork
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(MDCUnitOfWork.class);
    private final String pattern;
    private final String originalBreadcrumbId;
    private final String originalExchangeId;
    private final String originalMessageId;
    private final String originalCorrelationId;
    private final String originalRouteId;
    private final String originalStepId;
    private final String originalCamelContextId;
    private final String originalTransactionKey;

    public MDCUnitOfWork(Exchange exchange, InflightRepository inflightRepository, String pattern, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        super(exchange, LOG, inflightRepository, allowUseOriginalMessage, useBreadcrumb);
        this.pattern = pattern;
        this.originalExchangeId = MDC.get((String)"camel.exchangeId");
        this.originalMessageId = MDC.get((String)"camel.messageId");
        this.originalBreadcrumbId = MDC.get((String)"camel.breadcrumbId");
        this.originalCorrelationId = MDC.get((String)"camel.correlationId");
        this.originalRouteId = MDC.get((String)"camel.routeId");
        this.originalStepId = MDC.get((String)"camel.stepId");
        this.originalCamelContextId = MDC.get((String)"camel.contextId");
        this.originalTransactionKey = MDC.get((String)"camel.transactionKey");
        this.prepareMDC(exchange);
    }

    protected void prepareMDC(Exchange exchange) {
        Route current;
        String breadcrumbId;
        MDC.put((String)"camel.exchangeId", (String)exchange.getExchangeId());
        String msgId = exchange.getMessage().getMessageId();
        MDC.put((String)"camel.messageId", (String)msgId);
        MDC.put((String)"camel.contextId", (String)exchange.getContext().getName());
        String corrId = (String)exchange.getProperty(ExchangePropertyKey.CORRELATION_ID, String.class);
        if (corrId != null) {
            MDC.put((String)"camel.correlationId", (String)corrId);
        }
        if ((breadcrumbId = (String)exchange.getIn().getHeader("breadcrumbId", String.class)) != null) {
            MDC.put((String)"camel.breadcrumbId", (String)breadcrumbId);
        }
        if ((current = this.getRoute()) != null) {
            MDC.put((String)"camel.routeId", (String)current.getRouteId());
        }
    }

    @Override
    public UnitOfWork newInstance(Exchange exchange) {
        return new MDCUnitOfWork(exchange, this.inflightRepository, this.pattern, this.allowUseOriginalMessage, this.useBreadcrumb);
    }

    @Override
    public void pushRoute(Route route) {
        super.pushRoute(route);
        if (route != null) {
            MDC.put((String)"camel.routeId", (String)route.getRouteId());
        } else {
            MDC.remove((String)"camel.routeId");
        }
    }

    @Override
    public Route popRoute() {
        Route answer = super.popRoute();
        Route previous = this.getRoute();
        if (previous != null) {
            MDC.put((String)"camel.routeId", (String)previous.getRouteId());
        } else {
            MDC.remove((String)"camel.routeId");
        }
        return answer;
    }

    @Override
    public void beginTransactedBy(Object key) {
        MDC.put((String)"camel.transactionKey", (String)key.toString());
        super.beginTransactedBy(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        MDC.remove((String)"camel.transactionKey");
        super.endTransactedBy(key);
    }

    @Override
    public boolean isBeforeAfterProcess() {
        return true;
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        this.prepareMDC(exchange);
        String stepId = (String)exchange.getProperty(ExchangePropertyKey.STEP_ID, String.class);
        if (stepId != null) {
            MDC.put((String)"camel.stepId", (String)stepId);
        }
        AsyncCallback uowCallback = super.beforeProcess(processor, exchange, callback);
        return new MDCCallback(uowCallback, this.pattern);
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
        String stepId = (String)exchange.getProperty(ExchangePropertyKey.STEP_ID, String.class);
        if (stepId == null) {
            MDC.remove((String)"camel.stepId");
        }
        this.clear();
    }

    public void clear() {
        if (this.originalBreadcrumbId != null) {
            MDC.put((String)"camel.breadcrumbId", (String)this.originalBreadcrumbId);
        } else {
            MDC.remove((String)"camel.breadcrumbId");
        }
        if (this.originalExchangeId != null) {
            MDC.put((String)"camel.exchangeId", (String)this.originalExchangeId);
        } else {
            MDC.remove((String)"camel.exchangeId");
        }
        if (this.originalMessageId != null) {
            MDC.put((String)"camel.messageId", (String)this.originalMessageId);
        } else {
            MDC.remove((String)"camel.messageId");
        }
        if (this.originalCorrelationId != null) {
            MDC.put((String)"camel.correlationId", (String)this.originalCorrelationId);
        } else {
            MDC.remove((String)"camel.correlationId");
        }
        if (this.originalRouteId != null) {
            MDC.put((String)"camel.routeId", (String)this.originalRouteId);
        } else {
            MDC.remove((String)"camel.routeId");
        }
        if (this.originalStepId != null) {
            MDC.put((String)"camel.stepId", (String)this.originalStepId);
        } else {
            MDC.remove((String)"camel.stepId");
        }
        if (this.originalCamelContextId != null) {
            MDC.put((String)"camel.contextId", (String)this.originalCamelContextId);
        } else {
            MDC.remove((String)"camel.contextId");
        }
        if (this.originalTransactionKey != null) {
            MDC.put((String)"camel.transactionKey", (String)this.originalTransactionKey);
        } else {
            MDC.remove((String)"camel.transactionKey");
        }
    }

    @Override
    public void done(Exchange exchange) {
        super.done(exchange);
        this.clear();
    }

    @Override
    protected void onDone() {
        super.onDone();
        this.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.clear();
    }

    public void start() {
    }

    public void stop() {
        this.clear();
    }

    @Override
    public String toString() {
        return "MDCUnitOfWork";
    }

    private static final class MDCCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final String breadcrumbId;
        private final String exchangeId;
        private final String messageId;
        private final String correlationId;
        private final String routeId;
        private final String camelContextId;
        private final Map<String, String> custom;

        private MDCCallback(AsyncCallback delegate, String pattern) {
            this.delegate = delegate;
            this.exchangeId = MDC.get((String)"camel.exchangeId");
            this.messageId = MDC.get((String)"camel.messageId");
            this.breadcrumbId = MDC.get((String)"camel.breadcrumbId");
            this.correlationId = MDC.get((String)"camel.correlationId");
            this.camelContextId = MDC.get((String)"camel.contextId");
            this.routeId = MDC.get((String)"camel.routeId");
            if (pattern != null) {
                this.custom = new HashMap<String, String>();
                Map mdc = MDC.getCopyOfContextMap();
                if (mdc != null) {
                    if ("*".equals(pattern)) {
                        this.custom.putAll(mdc);
                    } else {
                        String[] patterns = pattern.split(",");
                        mdc.forEach((k, v) -> {
                            if (PatternHelper.matchPatterns((String)k, (String[])patterns)) {
                                this.custom.put((String)k, (String)v);
                            }
                        });
                    }
                }
            } else {
                this.custom = null;
            }
        }

        public void done(boolean doneSync) {
            try {
                if (!doneSync) {
                    if (this.breadcrumbId != null) {
                        MDC.put((String)"camel.breadcrumbId", (String)this.breadcrumbId);
                    }
                    if (this.exchangeId != null) {
                        MDC.put((String)"camel.exchangeId", (String)this.exchangeId);
                    }
                    if (this.messageId != null) {
                        MDC.put((String)"camel.messageId", (String)this.messageId);
                    }
                    if (this.correlationId != null) {
                        MDC.put((String)"camel.correlationId", (String)this.correlationId);
                    }
                    if (this.camelContextId != null) {
                        MDC.put((String)"camel.contextId", (String)this.camelContextId);
                    }
                    if (this.custom != null) {
                        this.custom.forEach(MDC::put);
                    }
                }
                if (this.routeId != null) {
                    MDC.put((String)"camel.routeId", (String)this.routeId);
                }
            }
            finally {
                this.delegate.done(doneSync);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

