/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.Service;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.resume.ConsumerListener;
import org.apache.camel.resume.ConsumerListenerAware;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.resume.AdapterHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;

public class DefaultRoute
extends ServiceSupport
implements Route {
    private final CamelContext camelContext;
    private NamedNode route;
    private final String routeId;
    private final String routeDescription;
    private final Resource sourceResource;
    private final String sourceLocation;
    private final String sourceLocationShort;
    private final List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>(0);
    private ManagementInterceptStrategy managementInterceptStrategy;
    private Boolean trace;
    private Boolean backlogTrace;
    private Boolean debug;
    private Boolean messageHistory;
    private Boolean logMask;
    private Boolean logExhaustedMessageBody;
    private Boolean streamCache;
    private Long delay;
    private Boolean autoStartup = Boolean.TRUE;
    private final List<RoutePolicy> routePolicyList = new ArrayList<RoutePolicy>();
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;
    private final Map<String, Processor> onCompletions = new HashMap<String, Processor>();
    private final Map<String, Processor> onExceptions = new HashMap<String, Processor>();
    private ResumeStrategy resumeStrategy;
    private ConsumerListener<?, ?> consumerListener;
    @Deprecated(since="3.17.0")
    private ErrorHandlerFactory errorHandlerFactory;
    private final ConcurrentMap<ErrorHandlerFactory, Set<NamedNode>> errorHandlers = new ConcurrentHashMap<ErrorHandlerFactory, Set<NamedNode>>();
    private final Endpoint endpoint;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<Service> services = new ArrayList<Service>();
    private final List<Service> servicesToStop = new ArrayList<Service>();
    private final StopWatch stopWatch = new StopWatch(false);
    private RouteError routeError;
    private Integer startupOrder;
    private RouteController routeController;
    private Processor processor;
    private Consumer consumer;

    public DefaultRoute(CamelContext camelContext, NamedNode route, String routeId, String routeDescription, Endpoint endpoint, Resource resource) {
        this.camelContext = camelContext;
        this.route = route;
        this.routeId = routeId;
        this.routeDescription = routeDescription;
        this.endpoint = endpoint;
        this.sourceResource = resource;
        this.sourceLocation = LoggerHelper.getSourceLocation((Object)route);
        this.sourceLocationShort = LoggerHelper.getLineNumberLoggerName((Object)route);
    }

    public String getId() {
        return this.routeId;
    }

    public String getNodePrefixId() {
        return (String)this.properties.get("nodePrefixId");
    }

    public boolean isCustomId() {
        return "true".equals(this.properties.get("customId"));
    }

    public boolean isCreatedByRestDsl() {
        return "true".equals(this.properties.get("rest"));
    }

    public boolean isCreatedByRouteTemplate() {
        return "true".equals(this.properties.get("template"));
    }

    public boolean isCreatedByKamelet() {
        return "true".equals(this.properties.get("kamelet"));
    }

    public String getGroup() {
        return (String)this.properties.get("group");
    }

    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration((long)delta);
    }

    public long getUptimeMillis() {
        return this.stopWatch.taken();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getDescription() {
        Object value = this.properties.get("description");
        return value != null ? (String)value : null;
    }

    public String getConfigurationId() {
        Object value = this.properties.get("configurationId");
        return value != null ? (String)value : null;
    }

    public Resource getSourceResource() {
        return this.sourceResource;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public String getSourceLocationShort() {
        return this.sourceLocationShort;
    }

    public void initializeServices() throws Exception {
        this.services.clear();
        this.gatherServices(this.services);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void addService(Service service) {
        if (!this.services.contains(service)) {
            this.services.add(service);
        }
    }

    public void addService(Service service, boolean forceStop) {
        if (forceStop) {
            if (!this.servicesToStop.contains(service)) {
                this.servicesToStop.add(service);
            }
        } else {
            this.addService(service);
        }
    }

    public void warmUp() {
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    protected void doStart() throws Exception {
        this.stopWatch.restart();
    }

    protected void doStop() throws Exception {
        this.stopWatch.stop();
    }

    protected void doShutdown() throws Exception {
        this.services.clear();
        ServiceHelper.stopAndShutdownService(this.servicesToStop);
        this.servicesToStop.clear();
    }

    public RouteError getLastError() {
        return this.routeError;
    }

    public void setLastError(RouteError routeError) {
        this.routeError = routeError;
    }

    public Integer getStartupOrder() {
        return this.startupOrder;
    }

    public void setStartupOrder(Integer startupOrder) {
        this.startupOrder = startupOrder;
    }

    public RouteController getRouteController() {
        return this.routeController;
    }

    public void setRouteController(RouteController routeController) {
        this.routeController = routeController;
    }

    public Boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public NamedNode getRoute() {
        return this.route;
    }

    public void clearRouteModel() {
        this.route = null;
        this.errorHandlerFactory = null;
        this.errorHandlers.clear();
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getRouteDescription() {
        return this.routeDescription;
    }

    public List<Processor> getEventDrivenProcessors() {
        return this.eventDrivenProcessors;
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setManagementInterceptStrategy(ManagementInterceptStrategy interceptStrategy) {
        this.managementInterceptStrategy = interceptStrategy;
    }

    public ManagementInterceptStrategy getManagementInterceptStrategy() {
        return this.managementInterceptStrategy;
    }

    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    public Boolean isTracing() {
        if (this.trace != null) {
            return this.trace;
        }
        return this.camelContext.isTracing();
    }

    public String getTracingPattern() {
        return this.camelContext.getTracingPattern();
    }

    public void setTracingPattern(String tracePattern) {
        this.camelContext.setTracingPattern(tracePattern);
    }

    public void setBacklogTracing(Boolean backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    public Boolean isBacklogTracing() {
        if (this.backlogTrace != null) {
            return this.backlogTrace;
        }
        return this.camelContext.isBacklogTracing();
    }

    public void setDebugging(Boolean debugging) {
        this.debug = debugging;
    }

    public Boolean isDebugging() {
        if (this.debug != null) {
            return this.debug;
        }
        return this.camelContext.isDebugging();
    }

    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    public Boolean isMessageHistory() {
        if (this.messageHistory != null) {
            return this.messageHistory;
        }
        return this.camelContext.isMessageHistory();
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public Boolean isLogMask() {
        if (this.logMask != null) {
            return this.logMask;
        }
        return this.camelContext.isLogMask();
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public Boolean isLogExhaustedMessageBody() {
        if (this.logExhaustedMessageBody != null) {
            return this.logExhaustedMessageBody;
        }
        return this.camelContext.isLogExhaustedMessageBody();
    }

    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    public Boolean isStreamCaching() {
        if (this.streamCache != null) {
            return this.streamCache;
        }
        return this.camelContext.isStreamCaching();
    }

    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    public Long getDelayer() {
        if (this.delay != null) {
            return this.delay;
        }
        return this.camelContext.getDelayer();
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.camelContext.setAllowUseOriginalMessage(allowUseOriginalMessage);
    }

    public Boolean isAllowUseOriginalMessage() {
        return this.camelContext.isAllowUseOriginalMessage();
    }

    public Boolean isCaseInsensitiveHeaders() {
        return this.camelContext.isCaseInsensitiveHeaders();
    }

    public void setCaseInsensitiveHeaders(Boolean caseInsensitiveHeaders) {
        this.camelContext.setCaseInsensitiveHeaders(caseInsensitiveHeaders);
    }

    public Boolean isAutowiredEnabled() {
        return this.camelContext.isAutowiredEnabled();
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.camelContext.setAutowiredEnabled(autowiredEnabled);
    }

    public ShutdownRoute getShutdownRoute() {
        if (this.shutdownRoute != null) {
            return this.shutdownRoute;
        }
        return this.camelContext.getShutdownRoute();
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        if (this.shutdownRunningTask != null) {
            return this.shutdownRunningTask;
        }
        return this.camelContext.getShutdownRunningTask();
    }

    public List<RoutePolicy> getRoutePolicyList() {
        return this.routePolicyList;
    }

    public Collection<Processor> getOnCompletions() {
        return this.onCompletions.values();
    }

    public void setOnCompletion(String onCompletionId, Processor processor) {
        this.onCompletions.put(onCompletionId, processor);
    }

    public Collection<Processor> getOnExceptions() {
        return this.onExceptions.values();
    }

    public Processor getOnException(String onExceptionId) {
        return this.onExceptions.get(onExceptionId);
    }

    public void setOnException(String onExceptionId, Processor processor) {
        this.onExceptions.put(onExceptionId, processor);
    }

    public Set<NamedNode> getErrorHandlers(ErrorHandlerFactory factory) {
        return this.errorHandlers.computeIfAbsent(factory, f -> new LinkedHashSet());
    }

    public void addErrorHandler(ErrorHandlerFactory factory, NamedNode onException) {
        this.errorHandlers.computeIfAbsent(factory, f -> new LinkedHashSet()).add(onException);
    }

    public void addErrorHandlerFactoryReference(ErrorHandlerFactory source, ErrorHandlerFactory target) {
        Set<NamedNode> previous;
        Set list = this.errorHandlers.computeIfAbsent(source, f -> new LinkedHashSet());
        if (list != (previous = this.errorHandlers.put(target, list)) && ObjectHelper.isNotEmpty(previous) && ObjectHelper.isNotEmpty((Collection)list)) {
            throw new IllegalStateException("Multiple references with different handlers");
        }
    }

    public String toString() {
        return "Route[" + this.getEndpoint() + " -> " + this.processor + "]";
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    protected void gatherServices(List<Service> services) throws Exception {
        this.gatherRootServices(services);
        ArrayList children = new ArrayList();
        for (Service service : services) {
            Set extra = ServiceHelper.getChildServices((Service)service);
            children.addAll(extra);
        }
        for (Service extra : children) {
            if (services.contains(extra)) continue;
            services.add(extra);
        }
    }

    private void gatherRootServices(List<Service> services) throws Exception {
        Service service;
        Processor resumeAdapter;
        Endpoint endpoint = this.getEndpoint();
        this.consumer = endpoint.createConsumer(this.processor);
        if (this.consumer != null) {
            services.add((Service)this.consumer);
            Consumer consumer = this.consumer;
            if (consumer instanceof RouteAware) {
                RouteAware routeAware = (RouteAware)consumer;
                routeAware.setRoute((Route)this);
            }
            if ((consumer = this.consumer) instanceof RouteIdAware) {
                RouteIdAware routeIdAware = (RouteIdAware)consumer;
                routeIdAware.setRouteId(this.getId());
            }
            if ((consumer = this.consumer) instanceof ResumeAware) {
                ResumeAware resumeAware = (ResumeAware)consumer;
                if (this.resumeStrategy != null) {
                    resumeAdapter = AdapterHelper.eval((CamelContext)this.getCamelContext(), (ResumeAware)resumeAware, (ResumeStrategy)this.resumeStrategy);
                    this.resumeStrategy.setAdapter((ResumeAdapter)resumeAdapter);
                    resumeAware.setResumeStrategy(this.resumeStrategy);
                }
            }
            if ((resumeAdapter = this.consumer) instanceof ConsumerListenerAware) {
                ConsumerListenerAware consumerListenerAware = (ConsumerListenerAware)resumeAdapter;
                consumerListenerAware.setConsumerListener(this.consumerListener);
            }
        }
        if ((resumeAdapter = this.processor) instanceof Service) {
            Service service2 = (Service)resumeAdapter;
            services.add(service2);
        }
        for (Processor p : this.onCompletions.values()) {
            if (!(p instanceof Service)) continue;
            service = (Service)p;
            services.add(service);
        }
        for (Processor p : this.onExceptions.values()) {
            if (!(p instanceof Service)) continue;
            service = (Service)p;
            services.add(service);
        }
    }

    public Navigate<Processor> navigate() {
        Processor answer = this.getProcessor();
        if (answer instanceof Navigate) {
            Object first;
            Navigate nav = (Navigate)answer;
            if (nav.next().size() == 1 && (first = nav.next().get(0)) instanceof Navigate) {
                return (Navigate)first;
            }
            return (Navigate)answer;
        }
        return null;
    }

    public List<Processor> filter(String pattern) {
        ArrayList<Processor> match = new ArrayList<Processor>();
        this.doFilter(pattern, this.navigate(), match);
        return match;
    }

    private void doFilter(String pattern, Navigate<Processor> nav, List<Processor> match) {
        List list = nav.next();
        if (list != null) {
            for (Processor proc : list) {
                String id = null;
                if (proc instanceof IdAware) {
                    IdAware idAware = (IdAware)proc;
                    id = idAware.getId();
                }
                if (PatternHelper.matchPattern(id, (String)pattern)) {
                    match.add(proc);
                }
                if (!(proc instanceof Navigate)) continue;
                Navigate child = (Navigate)proc;
                this.doFilter(pattern, (Navigate<Processor>)child, match);
            }
        }
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public boolean supportsSuspension() {
        return this.consumer instanceof Suspendable && this.consumer instanceof SuspendableService;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public void setConsumerListener(ConsumerListener<?, ?> consumerListener) {
        this.consumerListener = consumerListener;
    }
}

