/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.converter.ConverterStatistics;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.impl.converter.NoopTypeConverterStatistics;
import org.apache.camel.impl.converter.TypeConverterStatistics;
import org.apache.camel.impl.converter.TypeResolverHelper;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.TypeConvertible;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoreTypeConverterRegistry
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry {
    protected static final TypeConverter MISS_CONVERTER = new TypeConverterSupport(){

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            return (T)MISS_VALUE;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(CoreTypeConverterRegistry.class);
    protected final List<FallbackTypeConverter> fallbackConverters = new CopyOnWriteArrayList<FallbackTypeConverter>();
    protected final TypeConverter enumTypeConverter = new EnumTypeConverter();
    private final ConverterStatistics statistics;
    protected TypeConverterExists typeConverterExists = TypeConverterExists.Ignore;
    protected LoggingLevel typeConverterExistsLoggingLevel = LoggingLevel.DEBUG;
    private final Map<TypeConvertible<?, ?>, TypeConverter> converters = new ConcurrentHashMap(256);

    protected CoreTypeConverterRegistry(boolean statisticsEnabled) {
        this.statistics = statisticsEnabled ? new TypeConverterStatistics() : new NoopTypeConverterStatistics();
    }

    public boolean allowNull() {
        return false;
    }

    public void setInjector(Injector injector) {
        throw new UnsupportedOperationException();
    }

    public Injector getInjector() {
        throw new UnsupportedOperationException();
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    private <T> T fastConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (value == null) {
            return null;
        }
        if (type.equals(value.getClass())) {
            return (T)value;
        }
        if (type == Boolean.TYPE) {
            Boolean answer = ObjectConverter.toBoolean(value);
            CoreTypeConverterRegistry.requireNonNullBoolean(type, value, answer);
            return (T)answer;
        }
        if (type == Boolean.class && value instanceof String) {
            Boolean parsedBoolean = CoreTypeConverterRegistry.customParseBoolean((String)value);
            if (parsedBoolean != null) {
                return (T)parsedBoolean;
            }
        } else if (type.isPrimitive()) {
            Class<?> cls = value.getClass();
            if (cls == Integer.class || cls == Long.class) {
                return (T)value;
            }
        } else if (type == String.class) {
            Class<?> cls = value.getClass();
            if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                return (T)value.toString();
            }
        } else if (type.isEnum()) {
            try {
                return (T)this.enumTypeConverter.convertTo(type, exchange, value);
            }
            catch (Exception e) {
                throw this.createTypeConversionException(exchange, type, value, e);
            }
        }
        return null;
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        T ret;
        if (value != null && (ret = this.fastConvertTo(type, exchange, value)) != null) {
            return ret;
        }
        return (T)this.doConvertToAndStat(type, exchange, value, false);
    }

    private static Boolean customParseBoolean(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        T ret;
        if (value != null && (ret = this.fastConvertTo(type, exchange, value)) != null) {
            return ret;
        }
        Object answer = this.doConvertToAndStat(type, exchange, value, false);
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)answer;
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        return this.tryConvertTo(type, null, value);
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (value != null) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer = ObjectConverter.toBoolean(value);
                CoreTypeConverterRegistry.requireNonNullBoolean(type, value, answer);
                return (T)answer;
            }
            if (type == Boolean.class && value instanceof String) {
                Boolean parsedBoolean = CoreTypeConverterRegistry.customParseBoolean((String)value);
                if (parsedBoolean != null) {
                    return (T)parsedBoolean;
                }
            } else if (type.isPrimitive()) {
                Class<?> cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                Class<?> cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return (T)this.doConvertToAndStat(type, exchange, value, true);
    }

    private static <T> void requireNonNullBoolean(Class<T> type, Object value, Object answer) {
        if (answer == null) {
            throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
        }
    }

    protected Object doConvertToAndStat(Class<?> type, Exchange exchange, Object value, boolean tryConvert) {
        Object answer = null;
        try {
            answer = this.doConvertTo(type, exchange, value, tryConvert);
        }
        catch (Exception e) {
            if (!tryConvert) {
                this.statistics.incrementFailed();
            }
            if (tryConvert) {
                return null;
            }
            this.wrapConversionException(type, exchange, value, e);
        }
        if (answer == TypeConverter.MISS_VALUE) {
            if (!tryConvert) {
                this.statistics.incrementMiss();
            }
            return null;
        }
        if (!tryConvert) {
            this.statistics.incrementHit();
        }
        return answer;
    }

    private void wrapConversionException(Class<?> type, Exchange exchange, Object value, Exception e) {
        boolean execution;
        boolean bl = execution = ObjectHelper.getException(ExecutionException.class, (Throwable)e) != null || ObjectHelper.getException(CamelExecutionException.class, (Throwable)e) != null;
        if (execution) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
        throw this.createTypeConversionException(exchange, type, value, e);
    }

    private static Object nullToPrimitiveType(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.FALSE;
        }
        if (Integer.TYPE == type) {
            return 0;
        }
        if (Long.TYPE == type) {
            return 0L;
        }
        if (Byte.TYPE == type) {
            return (byte)0;
        }
        if (Short.TYPE == type) {
            return (short)0;
        }
        if (Double.TYPE == type) {
            return 0.0;
        }
        if (Float.TYPE == type) {
            return Float.valueOf(0.0f);
        }
        if (Character.TYPE == type) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean tryConvert) {
        if (value == null) {
            if (!tryConvert) {
                this.statistics.incrementNoop();
            }
            if (type.isPrimitive()) {
                return CoreTypeConverterRegistry.nullToPrimitiveType(type);
            }
            return null;
        }
        if (type.isInstance(value)) {
            if (!tryConvert) {
                this.statistics.incrementNoop();
            }
            return value;
        }
        if (!tryConvert) {
            this.statistics.incrementAttempt();
        }
        Class aClass = type.isPrimitive() ? ObjectHelper.convertPrimitiveTypeToWrapperType(type) : type;
        TypeConvertible typeConvertible = new TypeConvertible(value.getClass(), aClass);
        Object ret = this.tryCachedConverters(type, exchange, value, typeConvertible);
        if (ret != null) {
            return ret;
        }
        Object fallBackRet = this.tryFallback(type, exchange, value, tryConvert, typeConvertible);
        if (fallBackRet != null) {
            return fallBackRet;
        }
        TypeConverter assignableConverter = TypeResolverHelper.tryAssignableFrom(typeConvertible, this.converters);
        if (assignableConverter != null) {
            this.converters.put(typeConvertible, assignableConverter);
            return assignableConverter.convertTo(type, exchange, value);
        }
        TypeConverter objConverter = this.converters.get(new TypeConvertible(Object.class, type));
        if (objConverter != null) {
            this.converters.put(typeConvertible, objConverter);
            return objConverter.convertTo(type, exchange, value);
        }
        this.converters.put(typeConvertible, MISS_CONVERTER);
        return TypeConverter.MISS_VALUE;
    }

    private Object tryCachedConverters(Class<?> type, Exchange exchange, Object value, TypeConvertible<?, ?> typeConvertible) {
        Object ret;
        Object ret2;
        TypeConverter typeConverter = this.converters.get(typeConvertible);
        if (typeConverter != null && (ret2 = typeConverter.convertTo(type, exchange, value)) != null) {
            return ret2;
        }
        TypeConverter superConverterTc = TypeResolverHelper.tryMatch(typeConvertible, this.converters);
        if (superConverterTc != null && (ret = superConverterTc.convertTo(type, exchange, value)) != null) {
            this.converters.put(typeConvertible, superConverterTc);
            return ret;
        }
        return null;
    }

    private Object tryFallback(Class<?> type, Exchange exchange, Object value, boolean tryConvert, TypeConvertible<?, ?> typeConvertible) {
        for (FallbackTypeConverter fallback : this.fallbackConverters) {
            TypeConverter tc = fallback.getFallbackTypeConverter();
            Object rc = CoreTypeConverterRegistry.doConvert(type, exchange, value, tryConvert, tc);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc == TypeConverter.MISS_VALUE) {
                return TypeConverter.MISS_VALUE;
            }
            if (rc == null) continue;
            this.converters.put(typeConvertible, tc);
            if (fallback.isCanPromote()) {
                this.addOrReplaceTypeConverter(tc, typeConvertible);
            }
            return rc;
        }
        return null;
    }

    private static Object doConvert(Class<?> type, Exchange exchange, Object value, boolean tryConvert, TypeConverter converter) {
        if (tryConvert) {
            return converter.tryConvertTo(type, exchange, value);
        }
        return converter.convertTo(type, exchange, value);
    }

    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        return this.converters.get(new TypeConvertible(fromType, toType));
    }

    public void addConverter(TypeConvertible<?, ?> typeConvertible, TypeConverter typeConverter) {
        this.converters.put(typeConvertible, typeConverter);
    }

    public void addBulkTypeConverters(BulkTypeConverters bulkTypeConverters) {
    }

    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        LOG.trace("Adding type converter: {}", (Object)typeConverter);
        TypeConvertible typeConvertible = new TypeConvertible(fromType, toType);
        this.addOrReplaceTypeConverter(typeConverter, typeConvertible);
    }

    private void addOrReplaceTypeConverter(TypeConverter typeConverter, TypeConvertible<?, ?> typeConvertible) {
        TypeConverter converter = this.converters.get(typeConvertible);
        if (converter == MISS_CONVERTER) {
            this.converters.put(typeConvertible, typeConverter);
            return;
        }
        if (typeConverter != converter) {
            boolean add = true;
            if (converter != null) {
                add = this.onTypeConverterExists(typeConverter, typeConvertible, converter);
            }
            if (add) {
                this.converters.put(typeConvertible, typeConverter);
            }
        }
    }

    private boolean onTypeConverterExists(TypeConverter typeConverter, TypeConvertible<?, ?> typeConvertible, TypeConverter converter) {
        if (this.typeConverterExists == TypeConverterExists.Override) {
            CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
            logger.log("Overriding type converter from: " + String.valueOf(converter) + " to: " + String.valueOf(typeConverter));
            return true;
        }
        if (this.typeConverterExists == TypeConverterExists.Ignore) {
            CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
            logger.log("Ignoring duplicate type converter from: " + String.valueOf(converter) + " to: " + String.valueOf(typeConverter));
            return false;
        }
        throw new TypeConverterExistsException(typeConvertible.getTo(), typeConvertible.getFrom());
    }

    public boolean removeTypeConverter(Class<?> toType, Class<?> fromType) {
        LOG.trace("Removing type converter from: {} to: {}", fromType, toType);
        TypeConverter removed = this.converters.remove(new TypeConvertible(fromType, toType));
        return removed != null;
    }

    public void addTypeConverters(Object typeConverters) {
        throw new UnsupportedOperationException();
    }

    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        LOG.trace("Adding fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        this.fallbackConverters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
    }

    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.doLookup(toType, fromType);
    }

    @Deprecated(since="4.0.0")
    protected TypeConverter getOrFindTypeConverter(Class<?> toType, Class<?> fromType) {
        TypeConvertible typeConvertible = new TypeConvertible(fromType, toType);
        TypeConverter converter = this.converters.get(typeConvertible);
        if (converter == null && (converter = this.lookup(toType, fromType)) != null) {
            this.converters.put(typeConvertible, converter);
        }
        return converter;
    }

    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType) {
        return TypeResolverHelper.doLookup(toType, fromType, this.converters);
    }

    protected TypeConversionException createTypeConversionException(Exchange exchange, Class<?> type, Object value, Throwable cause) {
        if (cause instanceof TypeConversionException && ((TypeConversionException)cause).getToType() == type) {
            return (TypeConversionException)cause;
        }
        Object body = exchange != null ? MessageHelper.extractValueForLogging((Object)value, (Message)exchange.getIn()) : value;
        return new TypeConversionException(body, type, cause);
    }

    public TypeConverterRegistry.Statistics getStatistics() {
        return this.statistics;
    }

    public int size() {
        return this.converters.size();
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        CamelContextAware.trySetCamelContext((Object)this.enumTypeConverter, (CamelContext)this.getCamelContext());
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.statistics.logMappingStatisticsMessage(this.converters, MISS_CONVERTER);
        this.statistics.reset();
    }

    public static class FallbackTypeConverter {
        private final boolean canPromote;
        private final TypeConverter fallbackTypeConverter;

        FallbackTypeConverter(TypeConverter fallbackTypeConverter, boolean canPromote) {
            this.canPromote = canPromote;
            this.fallbackTypeConverter = fallbackTypeConverter;
        }

        public boolean isCanPromote() {
            return this.canPromote;
        }

        public TypeConverter getFallbackTypeConverter() {
            return this.fallbackTypeConverter;
        }
    }
}

