/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import java.util.Set;
import javax.validation.ValidatorFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.validator.BeanValidationException;
import org.apache.camel.component.bean.validator.BeanValidatorEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class BeanValidatorProducer
extends DefaultProducer {
    private ValidatorFactory validatorFactory;
    private Class<?> group;

    public BeanValidatorProducer(BeanValidatorEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Object bean = exchange.getIn().getBody();
        Set constraintViolations = this.group != null ? this.validatorFactory.getValidator().validate(bean, new Class[]{this.group}) : this.validatorFactory.getValidator().validate(bean, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new BeanValidationException(exchange, constraintViolations, exchange.getIn().getBody());
        }
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public Class<?> getGroup() {
        return this.group;
    }

    public void setGroup(Class<?> group) {
        this.group = group;
    }
}

