/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidatorFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.validator.BeanValidationException;
import org.apache.camel.component.bean.validator.BeanValidatorEndpoint;
import org.apache.camel.support.DefaultProducer;

public class BeanValidatorProducer
extends DefaultProducer {
    private ValidatorFactory validatorFactory;
    private Class<?> group;

    public BeanValidatorProducer(BeanValidatorEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        HashSet<ConstraintViolation<Object>> constraintViolations = new HashSet<ConstraintViolation<Object>>();
        if (exchange.getIn().getBody() instanceof Iterable) {
            Iterable body = (Iterable)exchange.getIn().getBody(Iterable.class);
            body.forEach(b -> constraintViolations.addAll(this.getConstraintViolationsForSingleBean(b, this.group)));
        } else {
            constraintViolations.addAll(this.getConstraintViolationsForSingleBean(exchange.getIn().getBody(), this.group));
        }
        if (!constraintViolations.isEmpty()) {
            throw new BeanValidationException(exchange, constraintViolations, exchange.getIn().getBody());
        }
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public Class<?> getGroup() {
        return this.group;
    }

    public void setGroup(Class<?> group) {
        this.group = group;
    }

    private Set<ConstraintViolation<Object>> getConstraintViolationsForSingleBean(Object bean, Class<?> group) {
        Set constraintViolations = this.group != null ? this.validatorFactory.getValidator().validate(bean, new Class[]{group}) : this.validatorFactory.getValidator().validate(bean, new Class[0]);
        return constraintViolations;
    }
}

