/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.BeanstalkExchangeHelper;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PutCommand.class);

    public PutCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException {
        Message in = exchange.getIn();
        long priority = BeanstalkExchangeHelper.getPriority(this.endpoint, in);
        int delay = BeanstalkExchangeHelper.getDelay(this.endpoint, in);
        int timeToRun = BeanstalkExchangeHelper.getTimeToRun(this.endpoint, in);
        long jobId = client.put(priority, delay, timeToRun, (byte[])in.getBody(byte[].class));
        LOG.debug("Created job {} with priority {}, delay {} seconds and time to run {}", new Object[]{jobId, priority, delay, timeToRun});
        this.answerWith(exchange, "beanstalk.jobId", jobId);
    }
}

