/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Message;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindyKeyValuePairFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyKeyValuePairFactory.class);
    private Map<Integer, KeyValuePairField> mapKeyValuePairField = new LinkedHashMap<Integer, KeyValuePairField>();
    private Map<Integer, Field> mapAnnotedField = new LinkedHashMap<Integer, Field>();
    private String keyValuePairSeparator;
    private String pairSeparator;

    public BindyKeyValuePairFactory(PackageScanClassResolver resolver, String packageName) throws Exception {
        super(resolver, packageName);
        this.initKeyValuePairModel();
    }

    public void initKeyValuePairModel() throws Exception {
        this.initAnnotedFields();
        this.initMessageParameters();
    }

    @Override
    public void initAnnotedFields() {
        for (Class cl : this.models) {
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                KeyValuePairField keyValuePairField = field.getAnnotation(KeyValuePairField.class);
                if (keyValuePairField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Key declared in the class : " + cl.getName() + ", key : " + keyValuePairField.tag() + ", Field : " + keyValuePairField.toString()));
                    }
                    this.mapKeyValuePairField.put(keyValuePairField.tag(), keyValuePairField);
                    this.mapAnnotedField.put(keyValuePairField.tag(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class linked  : " + cl.getName() + ", Field" + field.toString()));
                }
                this.mapAnnotedLinkField.put(cl.getName(), field);
            }
        }
    }

    @Override
    public void bind(List<String> data, Map<String, Object> model) throws Exception {
        int pos = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Data : " + data));
        }
        while (pos < data.size()) {
            if (!data.get(pos).equals("")) {
                ObjectHelper.notNull((Object)this.keyValuePairSeparator, (String)"Key Value Pair not defined in the @Message annotation");
                String[] keyValuePair = data.get(pos).split(this.getKeyValuePairSeparator());
                int tag = Integer.parseInt(keyValuePair[0]);
                String value = keyValuePair[1];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key : " + tag + ", value : " + value));
                }
                KeyValuePairField keyValuePairField = this.mapKeyValuePairField.get(tag);
                ObjectHelper.notNull((Object)keyValuePairField, (String)("No tag defined for the field : " + tag));
                Field field = this.mapAnnotedField.get(tag);
                field.setAccessible(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Tag : " + tag + ", Data : " + value + ", Field type : " + field.getType()));
                }
                String pattern = keyValuePairField.pattern();
                Format<?> format = FormatFactory.getFormat(field.getType(), pattern, keyValuePairField.precision());
                field.set(model.get(field.getDeclaringClass().getName()), format.parse(value));
            }
            ++pos;
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, KeyValuePairField> keyValuePairFields = new TreeMap<Integer, KeyValuePairField>(this.mapKeyValuePairField);
        Iterator it = keyValuePairFields.keySet().iterator();
        ObjectHelper.notNull((Object)this.pairSeparator, (String)"The pair separator has not been instantiated or property not defined in the @Message annotation");
        char separator = Converter.getCharDelimitor(this.getPairSeparator());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Separator converted : '0x" + Integer.toHexString(separator) + "', from : " + this.getPairSeparator()));
        }
        while (it.hasNext()) {
            KeyValuePairField keyValuePairField = this.mapKeyValuePairField.get(it.next());
            ObjectHelper.notNull((Object)keyValuePairField, (String)"KeyValuePair is null !");
            Field field = this.mapAnnotedField.get(keyValuePairField.tag());
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Tag : " + keyValuePairField.tag() + ", Field type : " + field.getType() + ", class : " + field.getDeclaringClass().getName()));
            }
            String pattern = keyValuePairField.pattern();
            Format<?> format = FormatFactory.getFormat(field.getType(), pattern, keyValuePairField.precision());
            Object obj = model.get(field.getDeclaringClass().getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Model object : " + obj.toString()));
            }
            builder.append(keyValuePairField.tag() + this.getKeyValuePairSeparator() + format.format(field.get(obj)) + separator);
        }
        return builder.toString();
    }

    public String getPairSeparator() {
        return this.pairSeparator;
    }

    public String getKeyValuePairSeparator() {
        return this.keyValuePairSeparator;
    }

    private void initMessageParameters() {
        if (this.pairSeparator == null || this.keyValuePairSeparator == null) {
            for (Class cl : this.models) {
                Message message = cl.getAnnotation(Message.class);
                if (message == null) continue;
                ObjectHelper.notNull((Object)message.pairSeparator(), (String)"No Pair Separator has been defined in the @Message annotation !");
                this.pairSeparator = message.pairSeparator();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Pair Separator defined for the message : " + this.pairSeparator));
                }
                ObjectHelper.notNull((Object)message.keyValuePairSeparator(), (String)"No Key Value Pair Separator has been defined in the @Message annotation !");
                this.keyValuePairSeparator = message.keyValuePairSeparator();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key Value Pair Separator defined for the message : " + this.keyValuePairSeparator));
                }
                this.crlf = message.crlf();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Carriage return defined for the message : " + this.crlf));
            }
        }
    }
}

