/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.kvp;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyKeyValuePairFactory;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindyKeyValuePairDataFormat
implements DataFormat {
    private static final transient Log LOG = LogFactory.getLog(BindyKeyValuePairDataFormat.class);
    private String packageName;
    private BindyKeyValuePairFactory modelFactory;

    public BindyKeyValuePairDataFormat() {
    }

    public BindyKeyValuePairDataFormat(String packageName) {
        this.packageName = packageName;
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyKeyValuePairFactory factory = this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ArrayList models = (ArrayList)body;
        byte[] crlf = Converter.getByteReturn(factory.getCarriageReturn());
        for (Map model : models) {
            String result = factory.unbind(model);
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(crlf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyKeyValuePairFactory factory = this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        InputStreamReader in = new InputStreamReader(inputStream);
        Scanner scanner = new Scanner(in);
        ObjectHelper.notEmpty((String)factory.getPairSeparator(), (String)"The separator has not been defined in the annotation @Message.");
        String separator = factory.getPairSeparator();
        int count = 0;
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (ObjectHelper.isEmpty((Object)line)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Counter " + count++ + " : content : " + line));
                }
                Map<String, Object> model = factory.factory();
                List<String> result = Arrays.asList(line.split(separator));
                factory.bind(result, model);
                factory.link(model);
                models.add(model);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Graph of objects created : " + model));
            }
            ArrayList<Map<String, Object>> arrayList = models;
            return arrayList;
        }
        finally {
            scanner.close();
            ObjectHelper.close((Closeable)in, (String)"in", (Log)LOG);
        }
    }

    public BindyKeyValuePairFactory getFactory(PackageScanClassResolver resolver) throws Exception {
        if (this.modelFactory == null) {
            this.modelFactory = new BindyKeyValuePairFactory(resolver, this.packageName);
        }
        return this.modelFactory;
    }

    public void setModelFactory(BindyKeyValuePairFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

