/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Section;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindyCsvFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyCsvFactory.class);
    private Map<Integer, DataField> dataFields = new LinkedHashMap<Integer, DataField>();
    private Map<Integer, Field> annotedFields = new LinkedHashMap<Integer, Field>();
    private Map<String, Integer> sections = new HashMap<String, Integer>();
    private int numberOptionalFields;
    private int numberMandatoryFields;
    private int totalFields;
    private String separator;
    private boolean skipFirstLine;
    private boolean messageOrdered;

    public BindyCsvFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        super(resolver, packageNames);
        this.initCsvModel();
    }

    public void initCsvModel() throws Exception {
        this.initAnnotedFields();
        this.initCsvRecordParameters();
    }

    @Override
    public void initAnnotedFields() {
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Class retrieved : " + cl.getName()));
            }
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Position defined in the class : " + cl.getName() + ", position : " + dataField.pos() + ", Field : " + dataField.toString()));
                    }
                    if (dataField.required()) {
                        ++this.numberMandatoryFields;
                    } else {
                        ++this.numberOptionalFields;
                    }
                    this.dataFields.put(dataField.pos(), dataField);
                    this.annotedFields.put(dataField.pos(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class linked  : " + cl.getName() + ", Field" + field.toString()));
                }
                linkFields.add(field);
            }
            if (!linkFields.isEmpty()) {
                this.annotedLinkFields.put(cl.getName(), linkFields);
            }
            this.totalFields = this.numberMandatoryFields + this.numberOptionalFields;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Number of optional fields : " + this.numberOptionalFields));
            LOG.debug((Object)("Number of mandatory fields : " + this.numberMandatoryFields));
            LOG.debug((Object)("Total : " + this.totalFields));
        }
    }

    @Override
    public void bind(List<String> tokens, Map<String, Object> model) throws Exception {
        int pos = 0;
        int counterMandatoryFields = 0;
        for (String data : tokens) {
            DataField dataField = this.dataFields.get(pos);
            ObjectHelper.notNull((Object)dataField, (String)("No position " + pos + " defined for the field : " + data));
            if (dataField.required()) {
                ++counterMandatoryFields;
                if (data.equals("")) {
                    throw new IllegalArgumentException("The mandatory field defined at the position " + pos + " is empty !");
                }
            }
            Field field = this.annotedFields.get(pos);
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pos : " + pos + ", Data : " + data + ", Field type : " + field.getType()));
            }
            String pattern = dataField.pattern();
            Format<?> format = FormatFactory.getFormat(field.getType(), pattern, dataField.precision());
            Object modelField = model.get(field.getDeclaringClass().getName());
            Object value = null;
            value = !data.equals("") ? (Object)format.parse(data) : BindyCsvFactory.getDefaultValueforPrimitive(field.getType());
            field.set(modelField, value);
            ++pos;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Counter mandatory fields : " + counterMandatoryFields));
        }
        if (pos < this.totalFields) {
            throw new IllegalArgumentException("Some fields are missing (optional or mandatory) !!");
        }
        if (counterMandatoryFields < this.numberMandatoryFields) {
            throw new IllegalArgumentException("Some mandatory fields are missing !!");
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, DataField> dataFieldsSorted = new TreeMap<Integer, DataField>(this.dataFields);
        Iterator it = dataFieldsSorted.keySet().iterator();
        TreeMap<Integer, String> positions = new TreeMap<Integer, String>();
        ObjectHelper.notNull((Object)this.separator, (String)"The separator has not been instantiated or property not defined in the @CsvRecord annotation");
        char separator = Converter.getCharDelimitor(this.getSeparator());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Separator converted : '0x" + Integer.toHexString(separator) + "', from : " + this.getSeparator()));
        }
        while (it.hasNext()) {
            DataField dataField = (DataField)dataFieldsSorted.get(it.next());
            Field field = this.annotedFields.get(dataField.pos());
            field.setAccessible(true);
            Class<?> type = field.getType();
            String pattern = dataField.pattern();
            int precision = dataField.precision();
            Format<?> format = FormatFactory.getFormat(type, pattern, precision);
            Object modelField = model.get(field.getDeclaringClass().getName());
            if (modelField == null) continue;
            Object value = field.get(modelField);
            String strValue = null;
            if (this.isMessageOrdered()) {
                Integer key1 = this.sections.get(modelField.getClass().getName());
                Integer key2 = dataField.position();
                Integer keyGenerated = BindyCsvFactory.generateKey(key1, key2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key generated : " + String.valueOf(keyGenerated) + ", for section : " + key1));
                }
                if (value != null) {
                    strValue = format.format(value);
                }
                positions.put(keyGenerated, strValue);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Positions size : " + positions.size()));
                continue;
            }
            if (value != null) {
                strValue = format.format(value);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Data : " + value + ", value : " + strValue));
            }
            builder.append(strValue);
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        if (this.isMessageOrdered()) {
            Iterator posit = positions.keySet().iterator();
            while (posit.hasNext()) {
                String value = (String)positions.get(posit.next());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Value added at the position (" + posit + ") : " + value + separator));
                }
                builder.append(value);
                if (!it.hasNext()) continue;
                builder.append(separator);
            }
        }
        return builder.toString();
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean getSkipFirstLine() {
        return this.skipFirstLine;
    }

    public boolean isMessageOrdered() {
        return this.messageOrdered;
    }

    private void initCsvRecordParameters() {
        if (this.separator == null) {
            for (Class cl : this.models) {
                CsvRecord record = cl.getAnnotation(CsvRecord.class);
                Section section = cl.getAnnotation(Section.class);
                if (record != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Csv record : " + record.toString()));
                    }
                    this.skipFirstLine = record.skipFirstLine();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Skip First Line parameter of the CSV : " + this.skipFirstLine));
                    }
                    ObjectHelper.notNull((Object)record.separator(), (String)"No separator has been defined in the @Record annotation !");
                    this.separator = record.separator();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Separator defined for the CSV : " + this.separator));
                    }
                    this.crlf = record.crlf();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Carriage return defined for the CSV : " + this.crlf));
                    }
                }
                if (section == null) continue;
                ObjectHelper.notNull((Object)section.number(), (String)"No number has been defined for the section !");
                this.sections.put(cl.getName(), section.number());
            }
        }
    }
}

