/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Message;
import org.apache.camel.dataformat.bindy.annotation.Section;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindyKeyValuePairFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyKeyValuePairFactory.class);
    private Map<Integer, KeyValuePairField> keyValuePairFields = new LinkedHashMap<Integer, KeyValuePairField>();
    private Map<Integer, Field> annotedFields = new LinkedHashMap<Integer, Field>();
    private Map<String, Integer> sections = new HashMap<String, Integer>();
    private String keyValuePairSeparator;
    private String pairSeparator;
    private boolean messageOrdered;

    public BindyKeyValuePairFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        super(resolver, packageNames);
        this.initKeyValuePairModel();
    }

    public void initKeyValuePairModel() throws Exception {
        this.initAnnotedFields();
        this.initMessageParameters();
    }

    @Override
    public void initAnnotedFields() {
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                KeyValuePairField keyValuePairField = field.getAnnotation(KeyValuePairField.class);
                if (keyValuePairField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Key declared in the class : " + cl.getName() + ", key : " + keyValuePairField.tag() + ", Field : " + keyValuePairField.toString()));
                    }
                    this.keyValuePairFields.put(keyValuePairField.tag(), keyValuePairField);
                    this.annotedFields.put(keyValuePairField.tag(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class linked  : " + cl.getName() + ", Field" + field.toString()));
                }
                linkFields.add(field);
            }
            if (linkFields.isEmpty()) continue;
            this.annotedLinkFields.put(cl.getName(), linkFields);
        }
    }

    @Override
    public void bind(List<String> data, Map<String, Object> model) throws Exception {
        int pos = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Data : " + data));
        }
        while (pos < data.size()) {
            if (!data.get(pos).equals("")) {
                ObjectHelper.notNull((Object)this.keyValuePairSeparator, (String)"Key Value Pair not defined in the @Message annotation");
                String[] keyValuePair = data.get(pos).split(this.getKeyValuePairSeparator());
                int tag = Integer.parseInt(keyValuePair[0]);
                String keyValue = keyValuePair[1];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key : " + tag + ", value : " + keyValue));
                }
                KeyValuePairField keyValuePairField = this.keyValuePairFields.get(tag);
                ObjectHelper.notNull((Object)keyValuePairField, (String)("No tag defined for the field : " + tag));
                Field field = this.annotedFields.get(tag);
                field.setAccessible(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Tag : " + tag + ", Data : " + keyValue + ", Field type : " + field.getType()));
                }
                String pattern = keyValuePairField.pattern();
                Format<?> format = FormatFactory.getFormat(field.getType(), pattern, keyValuePairField.precision());
                Object modelField = model.get(field.getDeclaringClass().getName());
                Object value = format.parse(keyValue);
                field.set(modelField, value);
            }
            ++pos;
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, KeyValuePairField> keyValuePairFieldsSorted = new TreeMap<Integer, KeyValuePairField>(this.keyValuePairFields);
        Iterator it = keyValuePairFieldsSorted.keySet().iterator();
        TreeMap<Integer, String> positions = new TreeMap<Integer, String>();
        ObjectHelper.notNull((Object)this.pairSeparator, (String)"The pair separator has not been instantiated or property not defined in the @Message annotation");
        char separator = Converter.getCharDelimitor(this.getPairSeparator());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Separator converted : '0x" + Integer.toHexString(separator) + "', from : " + this.getPairSeparator()));
        }
        while (it.hasNext()) {
            KeyValuePairField keyValuePairField = (KeyValuePairField)keyValuePairFieldsSorted.get(it.next());
            ObjectHelper.notNull((Object)keyValuePairField, (String)"KeyValuePair is null !");
            Field field = this.annotedFields.get(keyValuePairField.tag());
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Tag : " + keyValuePairField.tag() + ", Field type : " + field.getType() + ", class : " + field.getDeclaringClass().getName()));
            }
            Class<?> type = field.getType();
            String pattern = keyValuePairField.pattern();
            int precision = keyValuePairField.precision();
            Format<?> format = FormatFactory.getFormat(type, pattern, precision);
            Object obj = model.get(field.getDeclaringClass().getName());
            if (obj == null) continue;
            Object keyValue = field.get(obj);
            if (this.isMessageOrdered()) {
                Integer key1 = this.sections.get(obj.getClass().getName());
                Integer key2 = keyValuePairField.position();
                Integer keyGenerated = BindyKeyValuePairFactory.generateKey(key1, key2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key generated : " + String.valueOf(keyGenerated) + ", for section : " + key1));
                }
                if (keyValue == null) continue;
                String valueFormated = format.format(keyValue);
                String value = keyValuePairField.tag() + this.getKeyValuePairSeparator() + valueFormated;
                positions.put(keyGenerated, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Positions size : " + positions.size()));
                continue;
            }
            if (keyValue == null) continue;
            String valueFormated = format.format(keyValue);
            String value = keyValuePairField.tag() + this.getKeyValuePairSeparator() + valueFormated + separator;
            builder.append(value);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Value added : " + keyValuePairField.tag() + this.getKeyValuePairSeparator() + valueFormated + separator));
        }
        if (this.isMessageOrdered()) {
            Iterator posit = positions.keySet().iterator();
            while (posit.hasNext()) {
                String value = (String)positions.get(posit.next());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Value added at the position (" + posit + ") : " + value + separator));
                }
                builder.append(value + separator);
            }
        }
        return builder.toString();
    }

    public String getPairSeparator() {
        return this.pairSeparator;
    }

    public String getKeyValuePairSeparator() {
        return this.keyValuePairSeparator;
    }

    public boolean isMessageOrdered() {
        return this.messageOrdered;
    }

    private void initMessageParameters() {
        if (this.pairSeparator == null || this.keyValuePairSeparator == null) {
            for (Class cl : this.models) {
                Message message = cl.getAnnotation(Message.class);
                Section section = cl.getAnnotation(Section.class);
                if (message != null) {
                    ObjectHelper.notNull((Object)message.pairSeparator(), (String)"No Pair Separator has been defined in the @Message annotation !");
                    this.pairSeparator = message.pairSeparator();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Pair Separator defined for the message : " + this.pairSeparator));
                    }
                    ObjectHelper.notNull((Object)message.keyValuePairSeparator(), (String)"No Key Value Pair Separator has been defined in the @Message annotation !");
                    this.keyValuePairSeparator = message.keyValuePairSeparator();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Key Value Pair Separator defined for the message : " + this.keyValuePairSeparator));
                    }
                    this.crlf = message.crlf();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Carriage return defined for the message : " + this.crlf));
                    }
                    this.messageOrdered = message.isOrdered();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Is the message ordered in output : " + this.messageOrdered));
                    }
                }
                if (section == null) continue;
                ObjectHelper.notNull((Object)section.number(), (String)"No number has been defined for the section !");
                this.sections.put(cl.getName(), section.number());
            }
        }
    }
}

