/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyFixedLengthFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(BindyFixedLengthFactory.class);
    boolean isOneToMany;
    private Map<Integer, DataField> dataFields = new LinkedHashMap<Integer, DataField>();
    private Map<Integer, Field> annotatedFields = new LinkedHashMap<Integer, Field>();
    private int numberOptionalFields;
    private int numberMandatoryFields;
    private int totalFields;
    private boolean hasHeader;
    private boolean skipHeader;
    private boolean isHeader;
    private boolean hasFooter;
    private boolean skipFooter;
    private boolean isFooter;
    private char paddingChar;
    private int recordLength;

    public BindyFixedLengthFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        super(resolver, packageNames);
        this.initFixedLengthModel();
    }

    public BindyFixedLengthFactory(PackageScanClassResolver resolver, PackageScanFilter scanFilter, String ... packageNames) throws Exception {
        super(resolver, packageNames, scanFilter);
        this.initFixedLengthModel();
    }

    public BindyFixedLengthFactory(PackageScanClassResolver resolver, Class<?> type) throws Exception {
        super(resolver, type);
        this.initFixedLengthModel();
    }

    public BindyFixedLengthFactory(PackageScanClassResolver resolver, PackageScanFilter scanFilter, Class<?> type) throws Exception {
        super(resolver, type, scanFilter);
        this.initFixedLengthModel();
    }

    public void initFixedLengthModel() throws Exception {
        this.initAnnotatedFields();
        this.initFixedLengthRecordParameters();
    }

    @Override
    public void initAnnotatedFields() {
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class retrieved: {}", (Object)cl.getName());
            }
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Position defined in the class: {}, position: {}, Field: {}", new Object[]{cl.getName(), dataField.pos(), dataField});
                    }
                    if (dataField.required()) {
                        ++this.numberMandatoryFields;
                    } else {
                        ++this.numberOptionalFields;
                    }
                    this.dataFields.put(dataField.pos(), dataField);
                    this.annotatedFields.put(dataField.pos(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class linked: {}, Field: {}", (Object)cl.getName(), (Object)field);
                }
                linkFields.add(field);
            }
            if (!linkFields.isEmpty()) {
                this.annotatedLinkFields.put(cl.getName(), linkFields);
            }
            this.totalFields = this.numberMandatoryFields + this.numberOptionalFields;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Number of optional fields: {}", (Object)this.numberOptionalFields);
            LOG.debug("Number of mandatory fields: {}", (Object)this.numberMandatoryFields);
            LOG.debug("Total: {}", (Object)this.totalFields);
        }
    }

    @Override
    public void bind(List<String> data, Map<String, Object> model, int line) throws Exception {
    }

    public void bind(String record, Map<String, Object> model, int line) throws Exception {
        int pos = 1;
        int counterMandatoryFields = 0;
        int offset = 1;
        Collection<DataField> c = this.dataFields.values();
        for (DataField dataField : c) {
            String token;
            int length = dataField.length();
            String delimiter = dataField.delimiter();
            if (length == 0 && dataField.lengthPos() != 0) {
                Field lengthField = this.annotatedFields.get(dataField.lengthPos());
                lengthField.setAccessible(true);
                Object modelObj = model.get(lengthField.getDeclaringClass().getName());
                Integer lengthObj = (Integer)lengthField.get(modelObj);
                length = lengthObj;
            }
            if (length < 1 && delimiter == null && dataField.lengthPos() == 0) {
                throw new IllegalArgumentException("Either length or delimiter must be specified for the field : " + dataField.toString());
            }
            if (offset - 1 <= -1) {
                throw new IllegalArgumentException("Offset/Position of the field " + dataField.toString() + " cannot be negative");
            }
            if (length > 0) {
                token = record.substring(offset - 1, offset + length - 1);
                offset += length;
            } else if (!delimiter.equals("")) {
                String tempToken = record.substring(offset - 1, record.length());
                token = tempToken.substring(0, tempToken.indexOf(delimiter));
                offset += token.length() + 1;
            } else {
                token = "";
            }
            if (dataField.trim()) {
                token = token.trim();
            }
            if (dataField.required()) {
                ++counterMandatoryFields;
                if (token.equals("")) {
                    throw new IllegalArgumentException("The mandatory field defined at the position " + pos + " is empty for the line: " + line);
                }
            }
            Field field = this.annotatedFields.get(dataField.pos());
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pos/Offset: {}, Data: {}, Field type: {}", new Object[]{offset, token, field.getType()});
            }
            Format<?> format = FormatFactory.getFormat(field.getType(), this.getLocale(), dataField);
            Object modelField = model.get(field.getDeclaringClass().getName());
            Object value = null;
            if (!token.equals("")) {
                try {
                    value = format.parse(token);
                }
                catch (FormatException ie) {
                    throw new IllegalArgumentException(ie.getMessage() + ", position: " + offset + ", line: " + line, ie);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Parsing error detected for field defined at the position/offset: " + offset + ", line: " + line, e);
                }
            } else {
                value = BindyFixedLengthFactory.getDefaultValueForPrimitive(field.getType());
            }
            field.set(modelField, value);
            ++pos;
        }
        if (offset <= record.length() && !record.substring(offset - 1, record.length()).trim().equals("")) {
            throw new IllegalArgumentException("Unexpected / unmapped characters found at the end of the fixed-length record at line : " + line);
        }
        LOG.debug("Counter mandatory fields: {}", (Object)counterMandatoryFields);
        if (pos < this.totalFields) {
            throw new IllegalArgumentException("Some fields are missing (optional or mandatory), line: " + line);
        }
        if (counterMandatoryFields < this.numberMandatoryFields) {
            throw new IllegalArgumentException("Some mandatory fields are missing, line: " + line);
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder buffer = new StringBuilder();
        HashMap<Integer, List<String>> results = new HashMap<Integer, List<String>>();
        for (Class clazz : this.models) {
            if (!model.containsKey(clazz.getName())) continue;
            Object obj = model.get(clazz.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Model object: {}, class: {}", obj, (Object)obj.getClass().getName());
            }
            if (obj == null) continue;
            this.generateFixedLengthPositionMap(clazz, obj, results);
        }
        TreeMap sortValues = new TreeMap(results);
        for (Map.Entry entry : sortValues.entrySet()) {
            List val = (List)entry.getValue();
            String value = (String)val.get(0);
            buffer.append(value);
        }
        return buffer.toString();
    }

    private void generateFixedLengthPositionMap(Class<?> clazz, Object obj, Map<Integer, List<String>> results) throws Exception {
        String result = "";
        for (Field field : clazz.getDeclaredFields()) {
            List<Object> list;
            field.setAccessible(true);
            DataField datafield = field.getAnnotation(DataField.class);
            if (datafield == null) continue;
            if (obj != null) {
                int fieldLength;
                Class<?> type = field.getType();
                Format<?> format = FormatFactory.getFormat(type, this.getLocale(), datafield);
                Object value = field.get(obj);
                result = this.formatString(format, value);
                if (datafield.trim()) {
                    result = result.trim();
                }
                if ((fieldLength = datafield.length()) == 0 && datafield.lengthPos() > 0) {
                    List<String> resultVals = results.get(datafield.lengthPos());
                    fieldLength = Integer.valueOf(resultVals.get(0));
                }
                if (fieldLength <= 0 && datafield.delimiter().equals("") && datafield.lengthPos() == 0) {
                    throw new IllegalArgumentException("Either a delimiter value or length for the field: " + field.getName() + " is mandatory.");
                }
                if (!datafield.delimiter().equals("")) {
                    result = result + datafield.delimiter();
                } else {
                    String align = datafield.align();
                    char padCharField = datafield.paddingChar();
                    StringBuilder temp = new StringBuilder();
                    if (result.length() < fieldLength) {
                        char padChar = padCharField == '\u0000' ? this.paddingChar : padCharField;
                        if (align.contains("R")) {
                            temp.append(this.generatePaddingChars(padChar, fieldLength, result.length()));
                            temp.append(result);
                        } else if (align.contains("L")) {
                            temp.append(result);
                            temp.append(this.generatePaddingChars(padChar, fieldLength, result.length()));
                        } else {
                            throw new IllegalArgumentException("Alignment for the field: " + field.getName() + " must be equal to R for RIGHT or L for LEFT");
                        }
                        result = temp.toString();
                    } else if (result.length() > fieldLength) {
                        if (datafield.clip()) {
                            result = result.substring(0, fieldLength);
                        } else {
                            throw new IllegalArgumentException("Length for the " + field.getName() + " must not be larger than allowed, was: " + result.length() + ", allowed: " + fieldLength);
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value to be formatted: {}, position: {}, and its formatted value: {}", new Object[]{value, datafield.pos(), result});
                }
            } else {
                result = "";
            }
            Integer key = datafield.pos();
            if (!results.containsKey(key)) {
                list = new LinkedList<String>();
                list.add(result);
                results.put(key, list);
                continue;
            }
            list = results.get(key);
            list.add(result);
        }
    }

    private String generatePaddingChars(char pad, int lengthField, int lengthString) {
        StringBuilder buffer = new StringBuilder();
        int size = lengthField - lengthString;
        for (int i = 0; i < size; ++i) {
            buffer.append(Character.toString(pad));
        }
        return buffer.toString();
    }

    private void initFixedLengthRecordParameters() {
        for (Class cl : this.models) {
            FixedLengthRecord record = cl.getAnnotation(FixedLengthRecord.class);
            if (record == null) continue;
            LOG.debug("Fixed length record: {}", (Object)record);
            this.crlf = record.crlf();
            LOG.debug("Carriage return defined for the CSV: {}", (Object)this.crlf);
            this.hasHeader = record.hasHeader();
            LOG.debug("Has Header: {}", (Object)this.hasHeader);
            this.skipHeader = record.skipHeader();
            this.hasFooter = record.hasFooter();
            LOG.debug("Has Footer: {}", (Object)this.hasFooter);
            this.skipFooter = record.skipFooter();
            this.isHeader = record.isHeader();
            this.isFooter = record.isFooter();
            this.paddingChar = record.paddingChar();
            LOG.debug("Padding char: {}", (Object)Character.valueOf(this.paddingChar));
            this.recordLength = record.length();
            LOG.debug("Length of the record: {}", (Object)this.recordLength);
            this.recordLength = record.length();
            LOG.debug("Length of the record: {}", (Object)this.recordLength);
        }
        if (this.hasHeader && this.isHeader) {
            throw new IllegalArgumentException("Record can not be configured with both 'isHeader=true' and 'hasHeader=true'");
        }
        if (this.hasFooter && this.isFooter) {
            throw new IllegalArgumentException("Record can not be configured with both 'isFooter=true' and 'hasFooter=true'");
        }
        if ((this.isHeader || this.isFooter) && (this.skipHeader || this.skipFooter)) {
            throw new IllegalArgumentException("skipHeader and/or skipFooter can not be configured on a record where 'isHeader=true' or 'isFooter=true'");
        }
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean skipHeader() {
        return this.skipHeader;
    }

    public boolean skipFooter() {
        return this.skipFooter;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isFooter() {
        return this.isFooter;
    }

    public char paddingchar() {
        return this.paddingChar;
    }

    public int recordLength() {
        return this.recordLength;
    }
}

